<?php

/*
 * This file is part of the Contao Live Update.
 *
 * Copyright (c) 2012-2019 Leo Feyer
 *
 * @license Proprietary
 */

if (version_compare(phpversion(), '5.3.2', '<')) {
    die('You need at least PHP 5.3.2 to execute .phar files.');
}

if (!extension_loaded('Phar')) {
    die('The PHP Phar extension is not enabled.');
}

if (!extension_loaded('openssl')) {
    die('The PHP OpenSSL extension is not enabled.');
}

if (function_exists('ioncube_loader_iversion') && ioncube_loader_iversion() < 40009) {
    die('The PHP ionCube Loader extension prior to version 4.0.9 cannot handle .phar files.');
}

if (false !== ($suhosin = ini_get('suhosin.executor.include.whitelist'))) {
    $allowed = array_map('trim', explode(',', $suhosin));

    if (!in_array('phar', $allowed) && !in_array('phar://', $allowed)) {
        die('The Suhosin extension does not allow to run .phar files.');
    }
}

function is_disabled($value) {
    return '' === $value || 0 === (int) $value || 'Off' === $value;
}

if (false !== ($multibyte = ini_get('zend.multibyte')) && !is_disabled($multibyte)) {
    $unicode = ini_get(version_compare(phpversion(), '5.4', '<') ? 'detect_unicode' : 'zend.detect_unicode');

    if (!is_disabled($unicode)) {
        die('The detect_unicode setting needs to be disabled in your php.ini.');
    }
}

if ('cgi-fcgi' === php_sapi_name() && extension_loaded('eaccelerator') && ini_get('eaccelerator.enable')) {
    die('The PHP eAccelerator extension cannot handle .phar files.');
}

function phar_rewrite() {
    list(, $file) = explode('update.phar.php', $_SERVER['REQUEST_URI']);

    if (file_exists('phar://update.phar.php' . $file)) {
        return $file;
    }

    return 'index.php';
}

Phar::interceptFileFuncs();
Phar::webPhar('update.phar.php', 'index.php', '', array(), 'phar_rewrite');
__HALT_COMPILER(); ?>
x  #               	   index.phpUM  !\UM  :3S      
   versions.json  !\           languages/nl.php
  !\
  7f.         languages/zh.php  !\  `g         languages/sv.phpO
  !\O
  >J
s         languages/en.php
  !\
  =_         languages/ja.php  !\  -/ڤ         languages/ru.php  !\  Y\\         languages/sr.phpR  !\R  iHMB         languages/fr.php  !\  O         languages/rm.php  !\           languages/es.php  !\  z4         languages/sl.php
  !\
  e         languages/de.phpx  !\x  LTD         languages/it.phpt  !\t  I         languages/cs.php
  !\
  'v         templates/unrelated.html  !\  +E         templates/process.html  !\  /d         templates/check.html~  !\~  BMH         templates/templates.html  !\  4Sp         templates/welcome.htmln  !\n           assets/css/update.css	  !\	  Lʤ         assets/css/install.css;  !\;           assets/css/basic.css"  !\"  s         assets/images/error.gifR  !\R           assets/images/loading.gif  !\  k-         assets/images/login.gif  !\  V[         assets/images/install.gif  !\  #         assets/images/ok.gif   !\   J<         assets/images/show.gifZ  !\Z  ^?         assets/images/hbg.jpgF  !\F  C^         assets/js/html5.js+  !\+  *YĤ         assets/js/update.js  !\  Q6         assets/js/mootools.js  !\  fj         vendor/Diff_View.php<1  !\<1  U      <?php define('TL_MODE','BE');require'../system/initialize.php';class LiveUpdate extends Backend{protected $version='10.23';protected $labels=array();public function __construct(){$this->import('BackendUser','User');parent::__construct();$this->User->authenticate();(!defined('REQUEST_TOKEN'))&&(define('REQUEST_TOKEN',''));}public static function run(){$t=new self();$t->check();$n=filter_var($_GET['do'],FILTER_SANITIZE_STRING);in_array($n,get_class_methods($t))?$t->$n():$t->welcome();}public function check(){$r=array('headline'=>$this->label('error'),'continue'=>$this->label('continue'));(!$this->User->isAdmin)&&($this->render('check.html',array_merge($r,array('text'=>$this->label('admin')))));(version_compare(VERSION,'2.5','<'))&&($this->render('check.html',array_merge($r,array('text'=>$this->label('tooOld')))));try{$s=new File('system/tmp/'.md5(uniqid(mt_rand(),true)));$s->close();$s->delete();}catch(Exception $e){(0===$e->getCode())&&($this->render('check.html',array_merge($r,array('text'=>$this->label('smh')))));}if(!isset($_SESSION['lu_version'])){$o=new Request();$o->send('https://update.contao.org/service/update.txt');($o->hasError())&&($this->render('check.html',array_merge($r,array('text'=>$this->error($o)))));$_SESSION['lu_version']=$o->response;}if(version_compare($this->version,$_SESSION['lu_version'],'<')){$o=new Request();$o->send('https://update.contao.org/service/get/update.phar.zip');if($o->hasError()){$this->render('check.html',array_merge($r,array('text'=>$this->error($o))));}else{$u='system/tmp/'.md5(microtime(true));$s=new File($u);$s->write($o->response);$s->close();$a=new ZipReader($u);$s=new File('contao/update.phar.php');$s->write($a->first()->unzip());$s->close();$this->purge();$_SESSION['lu_version']=$o->response;$this->redirect('contao/update.phar.php/index.php');}}}public function welcome(){$r=array('noselect'=>'','emptyLuid'=>'','luid'=>$GLOBALS['TL_CONFIG']['liveUpdateId'],'luidHelp'=>$this->label('enterId'),'target'=>$this->label('target'),'curver'=>sprintf($this->label('curver'),VERSION.'.'.BUILD),'run'=>$this->label('run'),'dbBackup'=>$this->label('dbBackup'),'dbBCommands'=>'','dbBCheckbox'=>'','dbBHelp'=>$this->label('dbBHelp'));$f=array_map('trim',explode(',',ini_get('disable_functions')));(function_exists('exec')&&!in_array('exec',$f))?($l='exec'):((function_exists('shell_exec')&&!in_array('shell_exec',$f))?($l='shell_exec'):($l=false));$c=$h='';if(false===$l){$r['dbBCommands']=$this->label('noExec');}else{$c=trim($l('command -v mysql'));$h=trim($l('command -v mysqldump'));if((''===$c ||''===$h)){$r['dbBCommands']=$this->label('noMysql');}else{$_SESSION['lu_mysql']=$c;$_SESSION['lu_mysqldump']=$h;$_SESSION['lu_exec']=$l;$r['dbBCheckbox']='<input type="checkbox" name="backup" class="tl_checkbox" value="1" checked>';$r['dbBCommands']=sprintf($this->label('backupOk'),$h,$c);}}$p=json_decode(file_get_contents('versions.json'));if($_POST){$d=true;$_SESSION['lu_target']=null;if($GLOBALS['TL_CONFIG']['liveUpdateId']!==$this->post('luid')){$GLOBALS['TL_CONFIG']['liveUpdateId']=$this->post('luid');$this->Config->update("\$GLOBALS['TL_CONFIG']['liveUpdateId']",$this->post('luid'));}$r['luid']=$this->post('luid');$_SESSION['lu_backup']=(false!==$l &&''!==$c &&''!==$h&&$this->post('backup'));if(empty($_POST['version'])){$d=false;$r['noselect']='<p class="tl_error">'.$this->label('noselect').'</p>';}else{$_SESSION['lu_source']=VERSION.'.'.BUILD;$this->target($p,$this->post('version'));}if($d){$this->purge();$this->redirect('contao/update.phar.php/index.php?do=process');}}$r['versions']='<table><thead><tr><th>Version</th><th>'.$this->label('comment').'</th><th>'.$this->label('notes').'</th></tr></thead><tfoot><tr><td colspan="3"><label class="tl_gray">'.$this->label('toggle').' <input type="checkbox" class="tl_checkbox" id="toggler" onclick="LiveUpdate.toggle()"></label></td></tfoot><tbody>';foreach($p[0] as $m=>$g){$f=(version_compare($m,'3.5','>=')&&version_compare(phpversion(),'5.4.0','<'));$r['versions'].='<tr class="'.($g->active?'active':'legacy hide').'"><th colspan="3">'.$m.'</th></tr>';if($f){$r['versions'].='<tr class="note"><th colspan="3">'.sprintf($this->label('php54'),phpversion()).'</th></tr>';}foreach($g->versions as $i=>$y){if(0===$i&&$g->active){$b='active';$w='<span class="tl_green">'.$this->label('stable').((VERSION.'.'.BUILD===$y)?$this->label('installed'):$this->label('recommended')).'</span>';}else{$b='legacy hide';$w='<span class="tl_red">'.$this->label('legacy').((VERSION.'.'.BUILD===$y)?$this->label('installed'):'').'</span>';}if($f){$b.=' disabled';}if('de'===$GLOBALS['TL_LANGUAGE']){$E='http://www.contao.org/de/news/contao_'.str_replace('.','-',$y).'.html';}else{$E='http://www.contao.org/en/news/contao-'.str_replace('.','_',$y).'.html';}$r['versions'].='<tr class="'.$b.'"><td><label><input type="radio" name="version" class="tl_radio" value="'.$y.'"'.(($y==VERSION.'.'.BUILD)?' checked':'').($f?' disabled':'').'> '.$y.'</label></td><td>'.$w.'</td><td><a href="'.$E.'" title="'.$this->label('noteTitle').'" target="_blank">'.$this->label('moreInfo').'</a></td></tr>';}}$r['versions'].='</tbody></table>';$this->render('welcome.html',$r);}public function process(){$this->render('process.html',array());}public function labels(){die(json_encode($this->labels));}public function compare(){if(empty($_SESSION['lu_target'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingArgs'));}$p=json_decode(file_get_contents('versions.json'));if(!$this->versionExists($p,$_SESSION['lu_target'])){header('HTTP/1.1 400 Bad Request');die($this->label('invalidVers').' '.$_SESSION['lu_target']);}if(!file_exists(TL_ROOT.'/system/tmp/'.$_SESSION['lu_target'].'.json')){$o=new Request();$o->send('https://download.contao.org/versions/'.$_SESSION['lu_target'].'.json');if($o->hasError()){header('HTTP/1.1 502 Bad Gateway');die($o->response?: $o->error);}else{$u='system/tmp/'.$_SESSION['lu_target'].'.json';$s=new File($u);$s->write($o->response);$s->close();}}$S=array();$x=json_decode(file_get_contents(TL_ROOT.'/system/tmp/'.$_SESSION['lu_target'].'.json'));$T=$N=0;foreach($x as $C=>$L){if(''===$L){continue;}if('robots.txt'===$C&&file_exists(TL_ROOT.'/robots.txt')){continue;}if(!file_exists(TL_ROOT.'/'.$C)){$S[]=$C;++$T;error_log(date('Y-m-d H:i:s').' [Missing] '.$C."\n",3,TL_ROOT.'/system/logs/update.log');}else{$A=str_replace("\r",'',file_get_contents(TL_ROOT.'/'.$C));if(0!==strncmp(md5($A),$L,10)){$S[]=$C;++$N;error_log(date('Y-m-d H:i:s').' [Corrupt] '.$C."\n",3,TL_ROOT.'/system/logs/update.log');}$A=null;}}if(empty($S)){header('HTTP/1.1 210 Completed');die($this->label('uptodate'));}else{$_SESSION['LIVE_UPDATE_FILES']=implode(',',$S);}(!$GLOBALS['TL_CONFIG']['coreOnlyMode']&&count(array_diff(scan(TL_ROOT.'/system/modules'),array('core','calendar','comments','devtools','faq','listing','news','newsletter','repository')))>0)&&($this->Config->update("\$GLOBALS['TL_CONFIG']['coreOnlyMode']",true));die(sprintf($this->label('stats'),$T,$N));}public function backup(){if(empty($_SESSION['LIVE_UPDATE_FILES'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingFile'));}if(empty($_SESSION['lu_target'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingArgs'));}if($_SESSION['lu_source']===$_SESSION['lu_target']){header('HTTP/1.1 209 Not Available');die($this->label('backupVM'));}if(empty($_SESSION['lu_mysql'])||empty($_SESSION['lu_mysqldump'])||empty($_SESSION['lu_exec'])){header('HTTP/1.1 209 Not Available');die($this->label('backupNA'));}if(empty($_SESSION['lu_backup'])||false===$_SESSION['lu_backup']){header('HTTP/1.1 209 Not Available');die($this->label('backupUD'));}$O=TL_ROOT.'/system/backup';if(!is_dir($O)){$s=new File('system/backup/.htaccess');$s->write("<IfModule !mod_authz_core.c>\n Order deny,allow\n Deny from all\n</IfModule>\n<IfModule mod_authz_core.c>\n Require all denied\n</IfModule>");$s->close();}$s=$O.'/mysql-'.$_SESSION['lu_source'].'.sql';$_SESSION['lu_exec']($_SESSION['lu_mysqldump'].' --host='.$GLOBALS['TL_CONFIG']['dbHost'].' --port='.$GLOBALS['TL_CONFIG']['dbPort'].' --user='.$GLOBALS['TL_CONFIG']['dbUser'].' --password="'.$GLOBALS['TL_CONFIG']['dbPass'].'"'.' --opt --lock-tables'.' '.$GLOBALS['TL_CONFIG']['dbDatabase'].' > '.$s);die(sprintf($this->label('backupOK'),'system/backup/mysql-'.$_SESSION['lu_source'].'.sql'));}public function download(){if(empty($_SESSION['LIVE_UPDATE_FILES'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingFile'));}if(empty($_SESSION['lu_target'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingArgs'));}$p=json_decode(file_get_contents('versions.json'));if(!$this->versionExists($p,$_SESSION['lu_target'])){header('HTTP/1.1 400 Bad Request');die($this->label('invalidVers').' '.$_SESSION['lu_target']);}$g='host='.$this->host();$g.='&id='.$GLOBALS['TL_CONFIG']['liveUpdateId'];$g.='&version='.$_SESSION['lu_source'];$g.='&target='.$_SESSION['lu_target'];$g.='&language='.(('de'===$GLOBALS['TL_LANGUAGE'])?'de':'en');$g.='&ip='.$this->server();$g.='&files='.$_SESSION['LIVE_UPDATE_FILES'];$o=new Request();$o->method='POST';$o->setHeader('Content-Type','application/x-www-form-urlencoded');$o->data=$g;$o->send('https://update.contao.org/service/update.php');if($o->hasError()){header('HTTP/1.1 502 Bad Gateway');die($o->response?: $o->error);}$M=md5(microtime(true));$s=new File('system/tmp/'.$M);$s->write($o->response);$s->close();unset($_SESSION['LIVE_UPDATE_FILES']);$_SESSION['LIVE_UPDATE_ARCHIVE']=$M;die($this->label('downloaded'));}public function extract(){if(empty($_SESSION['LIVE_UPDATE_ARCHIVE'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingZip'));}$_=0;$a=new ZipReader('system/tmp/'.$_SESSION['LIVE_UPDATE_ARCHIVE']);while($a->next()){++$_;$s=new File($a->file_name);$s->write($a->unzip());$s->close();}$this->import('Files');$this->Files->delete('system/tmp/'.$_SESSION['LIVE_UPDATE_ARCHIVE']);die(sprintf($this->label('extracted'),$_));}public function restore(){if(empty($_SESSION['lu_target'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingArgs'));}if($_SESSION['lu_source']==$_SESSION['lu_target']){header('HTTP/1.1 209 Not Available');die($this->label('backupVM'));}if(empty($_SESSION['lu_mysql'])||empty($_SESSION['lu_mysqldump'])||empty($_SESSION['lu_exec'])){header('HTTP/1.1 209 Not Available');die($this->label('backupNA'));}if(empty($_SESSION['lu_backup'])||false===$_SESSION['lu_backup']){header('HTTP/1.1 209 Not Available');die($this->label('backupUD'));}$s=TL_ROOT.'/system/backup/mysql-'.$_SESSION['lu_target'].'.sql';if(!is_file($s)){header('HTTP/1.1 209 Not Available');die($this->label('restoreNA'));}$D=$this->Database->prepare("SELECT * FROM tl_session WHERE name='BE_USER_AUTH'AND pid=?") ->execute($this->User->id);$_SESSION['lu_exec']($_SESSION['lu_mysql'].' --host='.$GLOBALS['TL_CONFIG']['dbHost'].' --port='.$GLOBALS['TL_CONFIG']['dbPort'].' --user='.$GLOBALS['TL_CONFIG']['dbUser'].' --password="'.$GLOBALS['TL_CONFIG']['dbPass'].'"'.' '.$GLOBALS['TL_CONFIG']['dbDatabase'].' < '.$s);$this->Database->query("TRUNCATE TABLE tl_session");$this->Database->prepare("INSERT INTO tl_session %s")->set($D->row())->execute();die(sprintf($this->label('restoreOK'),'system/backup/mysql-'.$_SESSION['lu_target'].'.sql'));}public function recompare(){if(empty($_SESSION['lu_target'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingArgs'));}if(!file_exists(TL_ROOT.'/system/tmp/'.$_SESSION['lu_target'].'.json')){header('HTTP/1.1 400 Bad Request');die($this->label('invalidVers').' '.$_SESSION['lu_target']);}$x=json_decode(file_get_contents(TL_ROOT.'/system/tmp/'.$_SESSION['lu_target'].'.json'));foreach($x as $C=>$L){if(''===$L){continue;}if('robots.txt'===$C&&file_exists(TL_ROOT.'/robots.txt')){continue;}if(!file_exists(TL_ROOT.'/'.$C)){header('HTTP/1.1 506 Failed');die($this->label('failed'));}$A=str_replace("\r",'',file_get_contents(TL_ROOT.'/'.$C));if(0!==strncmp(md5($A),$L,10)){header('HTTP/1.1 506 Failed');die($this->label('failed'));}$A=null;}$this->purge();die($this->label('updated'));}protected function runonce(){if(empty($_SESSION['lu_target'])){header('HTTP/1.1 400 Bad Request');die($this->label('missingArgs'));}if(version_compare($_SESSION['lu_target'],'3.0.0','>=')&&!$this->Database->tableExists('tl_files')){header('HTTP/1.1 209 Not Available');die($this->label('v3hint'));}(version_compare(VERSION,'2.10','>='))&&($this->handleRunOnce());die($this->label('completed'));}protected function templates(){$P=array();foreach(scan(TL_ROOT.'/system/modules') as $H){if(is_dir(TL_ROOT.'/system/modules/'.$H.'/templates')){$B=new RecursiveIteratorIterator( new RecursiveDirectoryIterator(TL_ROOT.'/system/modules/'.$H.'/templates',FilesystemIterator::UNIX_PATHS));while($B->valid()){if(!$B->isDot()){$j=pathinfo($B->getFilename(),PATHINFO_EXTENSION);(('html5'===$j ||'xhtml'===$j ||'tpl'===$j)&&($P[$B->getFilename()]=$B->getPathname()));}$B->next();}}}$F=array();$B=new RecursiveIteratorIterator( new RecursiveDirectoryIterator(TL_ROOT.'/templates',FilesystemIterator::UNIX_PATHS));while($B->valid()){if(!$B->isDot()){$j=pathinfo($B->getFilename(),PATHINFO_EXTENSION);(('html5'===$j ||'xhtml'===$j ||'tpl'===$j)&&($F[]=$B->getSubPathname()));}$B->next();}$r=array();if(empty($F)){$r['templates']='<p class="tl_info mt1">'.$this->label('noTemplates').'</p>';$this->render('templates.html',$r);exit;}include'phar://update.phar.php/vendor/Diff_View.php';foreach(array_unique($F) as $C){$I=basename($C);if(isset($P[$I])){$r['templates'].='<h4>'.$C.'</h4>';$A=new Diff_View( explode("\n",trim(file_get_contents($P[$I]))),explode("\n",trim(file_get_contents(TL_ROOT.'/templates/'.$C))));$r['templates'].=$A->Render(new Diff_View_Renderer_Html_Contao());}}$this->render('templates.html',$r);}protected function unrelated(){$p=json_decode(file_get_contents('versions.json'));if(!$this->versionExists($p,VERSION.'.'.BUILD)){$r['form']='<p class="tl_error mt1">'.$this->label('unsupported').'</p>';$this->render('unrelated.html',$r);}if(!file_exists(TL_ROOT.'/system/tmp/'.VERSION.'.'.BUILD.'.json')){$o=new Request();$o->send('https://download.contao.org/versions/'.VERSION.'.'.BUILD.'.json');if($o->hasError()){header('HTTP/1.1 502 Bad Gateway');die($o->response?: $o->error);}else{$u='system/tmp/'.VERSION.'.'.BUILD.'.json';$s=new File($u);$s->write($o->response);$s->close();}}$r=array();$x=json_decode(file_get_contents(TL_ROOT.'/system/tmp/'.VERSION.'.'.BUILD.'.json'));$q=$this->scan('',$x);if(empty($q)){$r['form']='<p class="tl_info mt1">'.$this->label('noUnrelated').'</p>';$this->render('unrelated.html',$r);}if($_POST){$R=$_POST['files'];$R=array_intersect($R,$q);if(!empty($R)){foreach($R as $s){if(is_dir(TL_ROOT.'/'.$s)){$f=new Folder($s);$f->delete();}else{$f=new File($s);$f->delete();}if(false!==($U=array_search($s,$q))){unset($q[$U]);}}}}$r['form']='<div class="tl_formbody"><input type="hidden" name="REQUEST_TOKEN" value="'.REQUEST_TOKEN.'"><ul id="file-list">';foreach($q as $s){$r['form'].='<li><label><input type="checkbox" name="files[]" value="'.htmlspecialchars($s).'"'.$this->checked($s).'> '.$s.'</label></li>';}$r['form'].='</ul></div><div class="tl_formbody_submit"><div class="tl_submit_container"><input type="submit" class="tl_submit" value="'.$this->label('purge').'"></div></div>';$this->render('unrelated.html',$r);}protected function scan($z,$x){$q=array();$W=array('assets/css','assets/images','assets/js','contao/update.phar.php','system/backup','system/cache','system/config/dcaconfig.php','system/config/initconfig.php','system/config/langconfig.php','system/config/localconfig.php','system/config/pathconfig.php','system/cron/cron.txt','system/html','system/logs','system/scripts','system/tmp');foreach(scan(TL_ROOT.'/'.$z) as $s){$U=($z?$z.'/':'').$s;(!isset($x->$U))?((!in_array($U,$W))&&($q[]=$U.(is_dir(TL_ROOT.'/'.$U)?'/':''))):((!in_array($U,$W)&&is_dir(TL_ROOT.'/'.$U))&&($q=array_merge($q,$this->scan($U,$x))));}return $q;}protected function checked($s){if('.skip'==$s ||'/.skip'===substr($s,-6)){return'';}if('.DS_Store'==$s ||'/.DS_Store'===substr($s,-10)){return'checked';}$X=array('assets/ace/','assets/contao/','assets/css3pie/','assets/fonts/','assets/highlighter/','assets/html5shiv/','assets/jquery/','assets/mootools/','assets/swipe/','assets/tinymce/','contao/','plugins/chosen/','plugins/codeMirror/','plugins/colorpicker/','plugins/css3pie/','plugins/datepicker/','plugins/highlighter/','plugins/html5shim/','plugins/idna/','plugins/mediabox/','plugins/mootools/','plugins/simplepie/','plugins/slimbox/','plugins/stylect/','plugins/swiftmailer/','plugins/tablesort/','plugins/tcpdf/','plugins/tinyMCE/','system/bin/','system/cron/','system/docs/','system/helper/','system/libraries/','system/themes/','system/modules/calendar/','system/modules/comments/','system/modules/core/','system/modules/devtools/','system/modules/faq/','system/modules/listing/','system/modules/news/','system/modules/newsletter/','system/modules/repository/','typolight/','vendor/');if(in_array($s,$X)){return' checked';}foreach($X as $C){if(0===strncmp($s,$C,strlen($C))){return' checked';}}return'';}protected function render($I,$r){$r += array('token'=>REQUEST_TOKEN,'h2'=>'Live Update (v'.$this->version.')','language'=>$GLOBALS['TL_LANGUAGE'],'agent'=>$this->agent(),'beLogin'=>$this->label('beLogin'));$V=$Y=array();$A=file_get_contents('templates/'.$I);preg_match_all('/\{([a-zA-Z0-9_]+)\}/',$A,$G);foreach($G[1] as $i=>$U){$V[]=$G[0][$i];isset($r[$U])?($Y[]=$r[$U]):($Y[]=$this->label($U));}die(str_replace($V,$Y,$A));}protected function label($U){if(empty($this->labels)){$Q=$GLOBALS['TL_LANGUAGE'];((!$Q||!file_exists('phar://update.phar.php/languages/'.$Q.'.php'))&&($Q='en'));$this->labels=include'phar://update.phar.php/languages/'.$Q.'.php';}return isset($this->labels[$U])?$this->labels[$U]:null;}protected function get($U){return version_compare(VERSION,'3.0','<')?$this->Input->get($U):Input::get($U);}protected function post($U){return version_compare(VERSION,'3.0','<')?$this->Input->post($U):Input::post($U);}protected function error(Request $o){return(null===$o->code)?$this->label('connect'):((''!==$o->response)?$o->response:sprintf($this->label('statcode'),$o->code));}protected function host(){$Z=$_SERVER['HTTP_HOST'];if(''===$Z){$Z=$_SERVER['SERVER_NAME'];((80!==$_SERVER['SERVER_PORT'])&&($Z.=':'.$_SERVER['SERVER_PORT']));}return preg_replace('/[^A-Za-z0-9\[\]\.:-]/','',$Z);}protected static function server(){$tt=$_SERVER['SERVER_ADDR'];(empty($tt))&&($tt=$_SERVER['LOCAL_ADDR']);(empty($tt))&&($tt=@gethostbyname($_SERVER['SERVER_NAME']));return $tt;}protected function agent(){return version_compare(VERSION,'2.10','<')?'':(version_compare(VERSION,'3.0','<')?$this->Environment->agent->class:Environment::get('agent')->class);}protected function target($p,$tn){foreach($p[0] as $g){if(in_array($tn,$g->versions)){$_SESSION['lu_target']=$tn;break;}}(!$_SESSION['lu_target'])&&die('Invalid version number: '.$tn);}protected function versionExists($p,$y){foreach($p[0] as $g){if(in_array($y,$g->versions)){return true;}}return false;}protected function purge(){foreach(array('config','dca','language','sql') as $O){if(is_dir(TL_ROOT.'/system/cache/'.$O)){$z=new Folder('system/cache/'.$O);$z->delete();}}(function_exists('opcache_reset'))&&opcache_reset();(function_exists('accelerator_reset'))&&accelerator_reset();(function_exists('apc_compile_file')&&!ini_get('apc.stat'))&&apc_compile_file('contao/update.phar.php');(function_exists('eaccelerator_purge')&&!ini_get('eaccelerator.check_mtime'))&&@eaccelerator_purge();if(function_exists('xcache_count')&&!ini_get('xcache.stat')){if(($_=xcache_count(XC_TYPE_PHP))>0){for($tr=0;$tr < $_;$tr++){xcache_clear_cache(XC_TYPE_PHP,$tr);}}}}}try{LiveUpdate::run();}catch(Exception $e){echo'<pre>';print_r($e);echo'</pre>';}[{"3.5":{"active":true,"versions":["3.5.40","3.5.39","3.5.38","3.5.37","3.5.36","3.5.35","3.5.34","3.5.33","3.5.32","3.5.31","3.5.30","3.5.29","3.5.28","3.5.27","3.5.26","3.5.25","3.5.24","3.5.23","3.5.22","3.5.21","3.5.20","3.5.19","3.5.18","3.5.17","3.5.16","3.5.15","3.5.14","3.5.13","3.5.12","3.5.11","3.5.10","3.5.9","3.5.8","3.5.7","3.5.6","3.5.5","3.5.4","3.5.3","3.5.2","3.5.1","3.5.0"]},"3.4":{"active":false,"versions":["3.4.5","3.4.4","3.4.3","3.4.2","3.4.1","3.4.0"]},"3.3":{"active":false,"versions":["3.3.7","3.3.6","3.3.5","3.3.4","3.3.3","3.3.2","3.3.1","3.3.0"]},"3.2":{"active":false,"versions":["3.2.21","3.2.20","3.2.19","3.2.18","3.2.17","3.2.16","3.2.15","3.2.14","3.2.13","3.2.12","3.2.11","3.2.10","3.2.9","3.2.8","3.2.7","3.2.6","3.2.5","3.2.4","3.2.3","3.2.2","3.2.1","3.2.0"]},"3.1":{"active":false,"versions":["3.1.5","3.1.4","3.1.3","3.1.2","3.1.1","3.1.0"]},"3.0":{"active":false,"versions":["3.0.6","3.0.5","3.0.4","3.0.3","3.0.2","3.0.1","3.0.0"]},"2.11":{"active":false,"versions":["2.11.17","2.11.16","2.11.15","2.11.14","2.11.13","2.11.12","2.11.11","2.11.10","2.11.9","2.11.8","2.11.7","2.11.6","2.11.5","2.11.4","2.11.3","2.11.2","2.11.1","2.11.0"]}}]<?php return array('error'=>'Er is een fout opgetreden','admin'=>'U dient beheerder te zijn om dit script uit te kunnen voeren.','smh'=>'U dient Safe Mode Hack te activeren om de Live Update te kunnen gebruiken.','enterId'=>'Geef uw <a href="https://update.contao.org" target="_blank">Live Update ID op</a>.','target'=>'Doel versie','curver'=>'U beschikt momenteel over Contao %s.','installed'=>'(geïnstalleerd)','recommended'=>'(aanbevolen)','run'=>'Start update','emptyLuid'=>'Vul uw Live Update ID in','noselect'=>'Selecteer de doel versie','uptodate'=>'Uw Contao versie is reeds up-to-date.','connect'=>'Kan geen verbinding maken met de Live Update server','statcode'=>'De aanvraag retourneerde de status code %s','continue'=>'Ga door','beLogin'=>'Terug naar het back-end','comment'=>'Commentaar','notes'=>'Opmerkingen release','toggle'=>'Toon oudere versies','stable'=>'Huidige versie','legacy'=>'Verouderde versie','noteTitle'=>'Lees de release aankondiging','tooOld'=>'U dient op zijn minst over Contao 2.5.0 te beschikken om gebruik te maken van de Live Update.','moreInfo'=>'Meer informatie','invalidVers'=>'Ongeldig versienummer','unsupported'=>'Niet ondersteunde Contao versie.','missingArgs'=>'De doel versie ontbreekt.','missingFile'=>'Lijst met bestanden ontbreekt. Start een nieuwe aanvraag.','missingZip'=>'Het update archief ontbreekt. Start een nieuwe aanvraag.','step'=>'Stap','protocol'=>'Installatie updaten','stats'=>'Vond %s ontbrekende en %s verschillende bestanden.','step_1'=>'Controle van de installatie bestanden','step_2'=>'Aanmaken van de database back-up','step_3'=>'Downloaden van het update archief','step_4'=>'Uitpakken van het update archief','step_5'=>'Herstelling van database back-up','step_6'=>'Opnieuw controleren van installatie bestanden','step_6a'=>'Verwerken van de "runonce" bestanden','step_7'=>'Aangepaste template bestanden','step_7_txt'=>'Toont het verschil tussen uw wijzigingen (groen) en de originele versie (rood).','step_8'=>'Niet verwante bestanden','step_8_txt'=>'Toont een lijst met bestanden welke niet tot de Contao core distributie behoren.','noUnrelated'=>'Geen onafhankelijke bestanden gevonden.','purge'=>'Geselecteerde bestanden opschonen','downloaded'=>'Het archief werd met succes gedownload.','extracted'=>'%s bestanden zijn uitgepakt.','updated'=>'Installatie bestanden zijn bijgewerkt.','failed'=>'Uw installatie kon <b>niet</b> worden geüpdatet. Heeft Contao de Safe Mode Hack nodig op uw server en is deze correct geconfigureerd?','completed'=>'De Live Update is met succes afgerond. Uw installatie is up to date.','dbBackup'=>'Database back-up','backupOk'=>'Opdrachten: %s en %s','noExec'=>'De PHP functies <em>exec()</em> of <em>shell_exec()</em> zijn niet beschibaar.','noMysql'=>'De opdrachten <em>mysql</em> en/of <em>mysqldump</em> werden niet gevonden.','backupVM'=>'Bron en doel versies zijn gelijk, dus geen back-up vereist.','backupNA'=>'Aan systeemvereisten voor het maken van back-ups werd niet voldaan.','backupUD'=>'De back-up optie is niet geselecteerd','backupOK'=>'De back-up is opgeslagen in %s.','restoreNA'=>'Geen overeenkomstig back-up bestand gevonden','restoreOK'=>'De database is hersteld van %s','noTemplates'=>'Er zijn geen aangepaste templates.','v3hint'=>'Ga verder naar het installatie tool voor bijwerken van de database update Contao 2 naar Contao 3! <a href="../install.php"> Open installatie tool </ a>','php54'=>'Om Contao 3.5+ te kunnen installeren, hebt u minstens PHP 5.4.0 nodig (uw versie PHP %s).',);<?php return array('error'=>'发生了一个错误','admin'=>'请在管理员权限下运行这个脚本.','smh'=>'需要激活安全模式Hack来使用在线更新','enterId'=>'请输入您的 <a href="https://update.contao.org" target="_blank">在线更新ID</a>.','target'=>'目标版本','curver'=>'当前Contao %s.','installed'=>' (安装)','recommended'=>' (推荐)','run'=>'开始更新','emptyLuid'=>'请输入您的在线更新ID','noselect'=>'请选择目标版本','uptodate'=>'您的Contao系统为最新版本.','connect'=>'不能连接在线更新服务器','statcode'=>'请求返回状态码 %s','continue'=>'继续','beLogin'=>'返回后台','comment'=>'注释','notes'=>'更新说明','toggle'=>'现实合法版本','stable'=>'当前版本','legacy'=>'过时的版本','noteTitle'=>'查阅更新声明','tooOld'=>'使用在线更新至少需要Contao 2.5.0版本.','moreInfo'=>'更多信息','invalidVers'=>'无效的版本号','unsupported'=>'不支持的Contao版本.','missingArgs'=>'目标版本缺失.','missingFile'=>'文件列表缺失. 请开始新的请求.','missingZip'=>'更新归档缺失. 请开始新的请求.','step'=>'步骤','protocol'=>'更新安装','stats'=>'找到 %s 个缺失和 %s 个不同的文件.','step_1'=>'正在检查安装文件','step_2'=>'正在创建数据库备份','step_3'=>'正在下载更新存档','step_4'=>'正在提取更新存档','step_5'=>'正在恢复数据库备份','step_6'=>'正在重新检查安装文件','step_6a'=>'正在处理“runonce”文件','step_7'=>'自定义模板文件','step_7_txt'=>'显示更改 (绿色)和原始版本 (红色)之间的差异.','step_8'=>'不相关的文件','step_8_txt'=>'显示不属于Contao核心的文件列表.','noUnrelated'=>'没有发现不相关的文件.','purge'=>'清除所选文件','downloaded'=>'存档成功下载.','extracted'=>'已提取%s个文件.','updated'=>'安装文件已成功更新.','failed'=>'安装<b>无法</b>更新. 服务器是否正确配置Contao需要的安全模式Hack?','completed'=>'已成功完成在线更新. 当前安装是最新的.','dbBackup'=>'数据库备份','backupOk'=>'命令: %s 和 %s','noExec'=>'PHP函数<em>exec()</em> 或 <em>shell_exec()</em> 无法使用.','noMysql'=>'无法找到 <em>mysql</em> 和/或 <em>mysqldump</em>命令.','backupVM'=>'源和目标版本相同，因此不需要备份.','backupNA'=>'创建备份的系统需求不满足.','backupUD'=>'备份选项已取消选择','backupOK'=>'备份已经保存到%s.','restoreNA'=>'没有找到匹配的备份文件','restoreOK'=>'数据库已从 %s 中恢复','noTemplates'=>'没有自定义模板.','v3hint'=>'请执行安装工具使数据库从 Contao2 更新到 Contao3 ! <a href="../install.php">打开安装工具</a>','php54'=>'安装Contao 3.5+, 至少需要 PHP 5.4.0 (目前PHP版本为 %s).',);<?php return array('error'=>'Ett fel uppstod','admin'=>'Du måste vara administratör för att kunna köra detta skript.','smh'=>'Du måste aktivera Safe Mode-hack för att kunna använda Live Update.','enterId'=>'Ange ditt <a href="https://update.contao.org" target="_blank">Live Update ID</a>.','target'=>'Målversion','curver'=>'Du har för nuvarande Contao %s.','installed'=>'(installerad)','recommended'=>'(rekommenderad)','run'=>'Starta uppgradering','emptyLuid'=>'Ange ditt Live Update ID','noselect'=>'Välj målversion','uptodate'=>'Din Contao-installation är redan aktuell.','connect'=>'Kunde inte ansluta till Live Update-servern','statcode'=>'Returnerad statuskod är %s','continue'=>'Fortsätt','beLogin'=>'Tillbaka till backend','comment'=>'Kommentar','notes'=>'Versionsanteckningar','toggle'=>'Visa äldre versioner','stable'=>'Aktuell version','legacy'=>'Utdaterad version','noteTitle'=>'Läs versionsmeddelanden','tooOld'=>'Du behöver minst Contao 2.5.0 för att kunna använda Live Update.','moreInfo'=>'Mer information','invalidVers'=>'Ogiltigt versionsnummer','unsupported'=>'Contao-versionen stöds ej.','missingArgs'=>'Målversionen saknas.','missingFile'=>'Fillistan saknas. Vänligen starta en ny begäran.','missingZip'=>'Uppdateringsarkivet saknas. Vänligen starta en ny begäran.','step'=>'Steg','protocol'=>'Uppdatera installation','stats'=>'Hittade %s saknade filer och %s filer som skiljer sig åt.','step_1'=>'Kontrollerar installationsfiler','step_2'=>'Skapar säkerhetskopia av databas','step_3'=>'Laddar ner det uppdaterade arkivet','step_4'=>'Packar upp det uppdaterade arkivet','step_5'=>'Återställer säkerhetskopia av databas','step_6'=>'Återkontrollerar installationsfiler','step_6a'=>'Processar "runonce"-filer','step_7'=>'Custom template files','step_7_txt'=>'Visar skillnaden mellan dina ändringar (gröna) och originalversionen (röda).','step_8'=>'Ej relaterade filer','step_8_txt'=>'Visar en lista över filer som inte hör till Contao-distributionen.','noUnrelated'=>'Inga icke relaterade filer hittades.','purge'=>'Kasta valda filer','downloaded'=>'Arkivet laddades ner utan problem.','extracted'=>'%s filer har packats upp.','updated'=>'Installationsfilerna har uppdaterats utan problem.','failed'=>'Din installation kunde <b>inte</b> uppgraderas. Kräver Contao Safe Mode-hack på din server och har du konfigurerat den korrekt?','completed'=>'Live Update har avslutats utan problem. Din installation är nu aktuell.','dbBackup'=>'Säkerhetskopiering av databas','backupOk'=>'Kommandon: %s och %s','noExec'=>'PHP-funktion <em>exec()</em> eller <em>shell_exec()</em> är inte tillgänglig.','noMysql'=>'Kommando <em>mysql</em> och/eller <em>mysqldump</em> kunde inte hittas.','backupVM'=>'Käll- och destinationsversionerna är samma så säkerhetskopiering är inte nödvändig.','backupNA'=>'Systemkraven för att skapa säkerhetskopior uppfylls inte.','backupUD'=>'Säkerhetskopiering har valts bort','backupOK'=>'Säkerhetskopia har sparats i %s.','restoreNA'=>'Ingen matchande säkerhetskopia hittades','restoreOK'=>'Databasen har återställts från %s','noTemplates'=>'Det finns inga egna mallar.','v3hint'=>'Fortsätt till installationsverktyget för databasuppdatering från Contao 2 till Contao 3! <a href="../install.php">Öppna installationsverktyget</a>','php54'=>'To install Contao 3.5+, you need at least PHP 5.4.0 (you have PHP %s).',);<?php return array('error'=>'An error occurred','admin'=>'You have to be an administrator to run this script.','smh'=>'You need to activate the Safe Mode Hack to use the Live Update.','enterId'=>'Please enter your <a href="https://update.contao.org" target="_blank">Live Update ID</a>.','target'=>'Target version','curver'=>'You currently have Contao %s.','installed'=>' (installed)','recommended'=>' (recommended)','run'=>'Start update','emptyLuid'=>'Please enter your Live Update ID','noselect'=>'Please select the target version','uptodate'=>'Your Contao installation is already up to date.','connect'=>'Could not connect to the Live Update server','statcode'=>'The request returned the status code %s','continue'=>'Continue','beLogin'=>'Back to the back end','comment'=>'Comment','notes'=>'Release notes','toggle'=>'Show legacy versions','stable'=>'Current version','legacy'=>'Outdated version','noteTitle'=>'Read the release announcement','tooOld'=>'You need at least Contao 2.5.0 to use the Live Update.','moreInfo'=>'More information','invalidVers'=>'Invalid version number','unsupported'=>'Unsupported Contao version.','missingArgs'=>'The target version is missing.','missingFile'=>'The file list is missing. Please start a new request.','missingZip'=>'The update archive is missing. Please start a new request.','step'=>'Step','protocol'=>'Update installation','stats'=>'Found %s missing and %s differing files.','step_1'=>'Checking the installation files','step_2'=>'Creating the database backup','step_3'=>'Downloading the update archive','step_4'=>'Extracting the update archive','step_5'=>'Restoring the database backup','step_6'=>'Rechecking the installation files','step_6a'=>'Processing the "runonce" files','step_7'=>'Custom template files','step_7_txt'=>'Shows the difference between your changes (green) and the original version (red).','step_8'=>'Unrelated files','step_8_txt'=>'Shows a list of files which do not belong to the Contao core distribution.','noUnrelated'=>'No unrelated files found.','purge'=>'Purge selected files','downloaded'=>'The archive was successfully downloaded.','extracted'=>'%s files have been extracted.','updated'=>'The installation files have been updated successfully.','failed'=>'Your installation could <b>not</b> be updated. Does Contao require the Safe Mode Hack on your server and did you configure it correctly?','completed'=>'The Live Update has been completed successfully. Your installation is up to date.','dbBackup'=>'Database backup','backupOk'=>'Commands: %s and %s','noExec'=>'The PHP functions <em>exec()</em> or <em>shell_exec()</em> are not available.','noMysql'=>'The commands <em>mysql</em> and/or <em>mysqldump</em> could not be found.','backupVM'=>'Source and target version are the same, so no backup required.','backupNA'=>'The system requirements for creating backups are not met.','backupUD'=>'The backup option has been deselected','backupOK'=>'The backup has been stored in %s.','restoreNA'=>'No matching backup file found','restoreOK'=>'The database has been restored from %s','noTemplates'=>'There are no custom templates.','v3hint'=>'Please proceed to the install tool for the database update from Contao 2 to Contao 3! <a href="../install.php">Open the install tool</a>','php54'=>'To install Contao 3.5+, you need at least PHP 5.4.0 (you have PHP %s).',);<?php return array('error'=>'エラーが発生しました','admin'=>'このスクリプトを実行するには管理者でなければなりません。','smh'=>'ライブアップデートを使用するためにはセーフモード対処を有効にする必要があります。','enterId'=>'使用する<a href="https://update.contao.org" target="_blank">ライブアップデートのID</a>を入力してください。','target'=>'目的のバージョン','curver'=>'現在のContaoのバージョンは%sです。','installed'=>' (インストール済み)','recommended'=>' (推奨)','run'=>'アップデートを開始','emptyLuid'=>'ライブアップデートのIDを入力してください。','noselect'=>'目的のバージョンを選択してください','uptodate'=>'インストールしているContaoは既に最新です。','connect'=>'ライブアップデートのサーバーに接続で来ませんでした','statcode'=>'リクエストに%sの状態コードが返りました。','continue'=>'続ける','beLogin'=>'バックエンドに戻る','comment'=>'コメント','notes'=>'リリースノート','toggle'=>'古いバージョンを表示','stable'=>'現在のバージョン','legacy'=>'古くなったバージョン','noteTitle'=>'リリースのアナウンスを読む','tooOld'=>'ライブアップデートを使用するには、少なくともContao 2.5.0が必要です。','moreInfo'=>'詳しい情報','invalidVers'=>'正しくないバージョン番号','unsupported'=>'サポートしていないContaoのバージョンです。','missingArgs'=>'目的とするバージョンがありません。','missingFile'=>'ファイルのリストがありません。新しいリクエストを開始してください。','missingZip'=>'更新のアーカイブがありません。新しいリクエストを開始してください。','step'=>'ステップ','protocol'=>'インストールしているContaoを更新','stats'=>'%s個の不足しているファイルと%s個の異なっているファイルを検出しました。','step_1'=>'インストールするファイルを検査中','step_2'=>'データベースのバックアップを作成中','step_3'=>'更新のアーカイブをダウンロード中','step_4'=>'更新のアーカイブを展開中','step_5'=>'データベースをバックアップから復元中','step_6'=>'インストールするファイルを再検査中','step_6a'=>'"runonce"ファイルを処理中','step_7'=>'カスタマイズしたテンプレートファイル','step_7_txt'=>'変更した部分(緑)、元のバージョン(赤)で相違点を表示します。','step_8'=>'無関係なファイル','step_8_txt'=>'Contaoのコア配布に属さないファイルを表示します。','noUnrelated'=>'無関係なファイルはありません。','purge'=>'選択しているファイルを消去','downloaded'=>'正しくアーカイブをダウンロードしました。','extracted'=>'%s個のファイルを展開しました。','updated'=>'インストールするファイルの更新を完了しました。','failed'=>'インストールしたContaoをアップデート<b>できません</b>でした。インストールしているサーバーではContaoはセーフモード対処が必要ですが、正しく構成しましたか?','completed'=>'正しくライブアップデートを完了しました。インストールしたContaoは最新です。','dbBackup'=>'データベースのバックアップ','backupOk'=>'コマンド: %s と %s','noExec'=>'PHPの関数<em>exec()</em>または<em>shell_exec()</em>を使用できません。','noMysql'=>'コマンドの<em>mysql</em>と<em>mysqldump</em>の両方、またはいずれかが見つかりません。','backupVM'=>'アップデートの元と先のバージョンは同一です、このためバックアップの必要はありません。','backupNA'=>'バックアップを作成するのに必要なシステム要件を満たしていません。','backupUD'=>'バックアップのオプションを選択していません。','backupOK'=>'%sにバックアップを保存しました。','restoreNA'=>'合致するバックアップのファイルがありません','restoreOK'=>'%sからデータベースを復元しました','noTemplates'=>'カスタマイズしたテンプレートはありません。','v3hint'=>'さらにContaoのインストールツールでバージョン3アップデートを実行しなければなりません! <a href="../install.php" target="_blank">インストールツールを開く</a>','php54'=>'Contao 3.5以降をインストールするには、少なくともPHP 5.4.0が必要です。(PHP %sが動作しています。)',);<?php return array('error'=>'Произошла ошибка','admin'=>'Вы должны быть администратором для запуска этого сценария.','smh'=>'Вам необходимо активировать Safe Mode Hack для использования онлайн обновления.','enterId'=>'Введите ваш <a href="https://update.contao.org" target="_blank">Live Update ID</a>.','target'=>'Версия','curver'=>'Вы используете Contao %s.','installed'=>' (установлена)','recommended'=>' (рекоммендуется)','run'=>'Запуск обновления','emptyLuid'=>'Введите ваш Live Update ID','noselect'=>'Выберите версию','uptodate'=>'Contao не требует обновления.','connect'=>'Не удалось подключиться к серверу онлайн обновления','statcode'=>'Запрос возвратил код статуса %s','continue'=>'Продолжить','beLogin'=>'Назад к панели управления','comment'=>'Комментарий','notes'=>'Информация о версии','toggle'=>'Показать устаревшие версии','stable'=>'Текущая версия','legacy'=>'Устаревшая версия','noteTitle'=>'Прочитать информацию о выпуске','tooOld'=>'Для использования онлайн обновления требуется Contao не ниже версии 2.5.0.','moreInfo'=>'Дополнительная информация','invalidVers'=>'Неверный номер версии','unsupported'=>'Неподдерживаемая версия Contao.','missingArgs'=>'Отсутствует целевая версия','missingFile'=>'Отсутствует список файлов. Создайте новый запрос.','missingZip'=>'Архив обновлении отсутствует. Создайте новый запрос.','step'=>'Шаг','protocol'=>'Установка обновления','stats'=>'Найдено потеряных %s и различающихся %s файлов.','step_1'=>'Проверка файлов установки','step_2'=>'Создание резервной копии базы данных','step_3'=>'Загрузка архива обновлений','step_4'=>'Извлечение архива обновлений','step_5'=>'Восстановление резервной копии базы данных','step_6'=>'Повторная проверка файлов установки','step_6a'=>'Обработка "runonce" файлов','step_7'=>'Пользовательские шаблоны','step_7_txt'=>'Показывает разницу между вашими изменениями (зеленый) и оригинальной версией (красный).','step_8'=>'Несвязанные файлы','step_8_txt'=>'Показывает список файлов не входящих в дистрибутив Contao.','noUnrelated'=>'Несвязанные файлы не найдены.','purge'=>'Очистить выбранные файлы','downloaded'=>'Архив успешно загружен.','extracted'=>'Извлечено файлов %s.','updated'=>'Установочные файлы были успешно обновлены.','failed'=>'Установка Contao <b>не</b> обновлена. Contao требуется Safe Mode Hack или сервер неправильно сконфигурирован.','completed'=>'Онлайн обновление успешно завершено. Установка Contao актуальна.','dbBackup'=>'Резервная копия базы данных','backupOk'=>'Команды: %s и %s','noExec'=>'PHP функции <em>exec()</em> и/или <em>shell_exec()</em> не доступны.','noMysql'=>'Команды <em>mysql</em> и/или <em>mysqldump</em> не найдены.','backupVM'=>'Версии совпадают, поэтому необходимости в резервном копировании нет.','backupNA'=>'Системные требования для создания резервных копий не выполнены.','backupUD'=>'Опция резервного копирования не выбрана','backupOK'=>'Резервная копия хранится в %s.','restoreNA'=>'Не найден подходящий файл резервной копии','restoreOK'=>'База данных была восстановлена ​​из %s.','noTemplates'=>'Не найдены пользовательские шаблоны.','v3hint'=>'Перейдите к мастеру установки для обновления базы данных Contao до версии 3! <a href="../install.php">Открыть мастер установки</a>','php54'=>'Для установки Contao версии 3.5 и выше, вам необходима как минимум PHP 5.4.0 (у вас PHP %s).',);<?php return array('error'=>'Дошло је до грешке','admin'=>'Да бисте покренули ову скрипту, морате да будете администратор.','smh'=>'Да бисте користили Live Update, морате да активирате Safe Mode Hack.','enterId'=>'Унесите ваш <a href="https://update.contao.org" target="_blank">Live Update ID</a>.','target'=>'Циљна верзија','curver'=>'Тренутно користите Contao %s. ','installed'=>'(инсталирано)','recommended'=>'(препоручено)','run'=>'Започни ажурирање','emptyLuid'=>'Унесите ваш Live Update ID','noselect'=>'Изаберите верзију на коју желите да извршите ажурирање','uptodate'=>'Ваша инсталација је ажурна.','connect'=>'Повезивање са сервером за ажурирање није успело.','statcode'=>'Захтев је вратио статусни код %s','continue'=>'Настави','beLogin'=>'Назад у БекЕнд','comment'=>'Коментар','notes'=>'Информације о верзији','toggle'=>'Прикажи претходне верзије','stable'=>'Тренутна верзија','legacy'=>'Застарела верзија','noteTitle'=>'Прочитај информације о верзији','tooOld'=>'Да бисте користили Live Update, морате да користите барем Contao 2.5.0.','moreInfo'=>'Више информација','invalidVers'=>'Неисправан број верзије','unsupported'=>'Верзија Contao која није подржана.','missingArgs'=>'Циљна верзија недостаје.','missingFile'=>'Листа фајлова недостаје. Поновите захтев.','missingZip'=>'Архива за ажурирање недостаје. Поновите захтев.','step'=>'Корак','protocol'=>'Инсталација ажурирања','stats'=>'Пронађено је %s фајлова који недостају и %s фајлова који су измењени.','step_1'=>'Провера инсталационих фајлова','step_2'=>'Креирање резервне копије базе ','step_3'=>'Преузимање архиве за ажурирање','step_4'=>'Распакивање архиве за ажурирање','step_5'=>'Примена резервне копије базе','step_6'=>'Поновна провера инсталационих фајлова','step_6a'=>'Обрада "runonce" фајлова','step_7'=>'Прилагођени фајлови шаблона','step_7_txt'=>'Разлике између промена које сте ви урадили (зелено) и оригиналне верзије (црвено).','step_8'=>'Неповезани фајлови','step_8_txt'=>'Листа фајлова који не припадају основној Contao дистрибуцији.','noUnrelated'=>'Нису пронађени неповезани фајлови.','purge'=>'Прочисти изабране фајлове','downloaded'=>'Архива је успешно преузета.','extracted'=>'Распаковано је %s фајлова.','updated'=>'Инсталациони фајлови су успешно ажурирани.','failed'=>'Ваша инсталација <b>није</b> ажурирана. Да ли Contao да користи Safe Mode Hack на вашем серверу и да ли сте га добро подесили?','completed'=>'Live Update је успешно завршен. Ваша инсталација је ажурна.','dbBackup'=>'Резервна копија базе','backupOk'=>'Команде: %s и %s','noExec'=>'PHP функције <em>exec()</em> или <em>shell_exec()</em> нису на доступне.','noMysql'=>'Команде <em>mysql</em> и/или <em>mysqldump</em> нису пронађене.','backupVM'=>'Изворна и одредишна верзија су идентичне тако да није потребно извршити прављење резервне копије.','backupNA'=>'Системски захтеви за креирање резервне копије нису испуњени.','backupUD'=>'Опција за правњење резервне копије није изабрана','backupOK'=>'Резервна копија је похрањена у %s.','restoreNA'=>'Није пронађен одговарајући фајл резервне копије','restoreOK'=>'Враћена је верзија базе из %s','noTemplates'=>'Нема прилагођених шаблона.','v3hint'=>'Наставите са инсталационим алатомза ажурирање базе са Contao 2 на Contao 3! <a href="../install.php">Покрени алат за инсталацију</a>','php54'=>'Да бисте инсталирали контао 3.5+ морате да користите барем PHP 5.4.0 (ваша верзија је PHP %s).',);<?php return array('error'=>'Une erreur s\'est produite', 'admin' => 'Vous devez être un administrateur pour exécuter ce script.', 'smh' => 'Vous devez activer le Safe Mode Hack pour pouvoir utiliser Live Update(service de mise à jour automatique de Contao).', 'enterId' => 'Veuillez saisir votre <a href="https://update.contao.org" target="_blank">Live Update ID</a>.', 'target' => 'Version cible', 'curver' => 'Vous avez actuellement Contao %s.', 'installed' => '(installée)', 'recommended' => '(recommandée)', 'run' => 'Démarrer la mise à jour', 'emptyLuid' => 'Saisir l\'ID de la mise à jour automatique','noselect'=>'Veuillez sélectionner la version cible','uptodate'=>'Votre installation de Contao est déjà à jour.','connect'=>'Impossible de se connecter au serveur de Live Update','statcode'=>'La requête a renvoyée le code d\'état %s', 'continue' => 'Continuer', 'beLogin' => 'Retour au back office', 'comment' => 'Commentaire', 'notes' => 'Notes de version', 'toggle' => 'Afficher les versions existantes', 'stable' => 'Version actuelle', 'legacy' => 'Version obsolète', 'noteTitle' => 'Lire l\'annonce de sortie','tooOld'=>'Vous devez avoir au moins Contao 2.5.0 pour utiliser le Live Update.','moreInfo'=>'Plus d\'informations', 'invalidVers' => 'Numéro de version non valide', 'unsupported' => 'Version de Contao non pris en charge.', 'missingArgs' => 'La version cible est manquante.', 'missingFile' => 'La liste des fichiers est manquante.Veuillez lancer une nouvelle requête.', 'missingZip' => 'L\'archive de mise à jour est manquante. Veuillez lancer une nouvelle requête.','step'=>'Étape','protocol'=>'Installation de la mise à jour','stats'=>'%s manquants et %s fichiers différents ont été trouvés.','step_1'=>'Vérification des fichiers d\'installation', 'step_2' => 'Création de la sauvegarde de la base de données', 'step_3' => 'Téléchargement de l\'archive de mise à pour','step_4'=>'Extraction de l\'archive de mise à jour', 'step_5' => 'Restauration de la sauvegarde de la base de données', 'step_6' => 'Nouvelle vérification des fichiers d\'installation','step_6a'=>'Traitement des fichiers "runonce"','step_7'=>'Fichiers de modèles personnalisés','step_7_txt'=>'Montre la différence entre vos modifications (vert) et la version originale (rouge).','step_8'=>'Fichiers sans rapport','step_8_txt'=>'Affiche une liste des fichiers qui n\'appartiennent pas à la distribution de base de Contao.', 'noUnrelated' => 'Aucun fichier sans rapport trouvé.', 'purge' => 'Purger les fichiers sélectionnés', 'downloaded' => 'L\'archive a été téléchargée avec succès.','extracted'=>'%s fichiers ont été extraits.','updated'=>'Les fichiers d\'installation ont été mis à jour avec succès.', 'failed' => 'Votre installation <b>ne peut pas</b> être mise à jour.Si Contao exige le Safe Mode Hack sur votre serveur,l\'avez-vous configuré correctement ?','completed'=>'La mise à jour automatique a été effectuée avec succès. Votre installation est à jour.','dbBackup'=>'Sauvegarde de la base','backupOk'=>'Commandes : %s et %s','noExec'=>'Les fonctions PHP <em>exec()</em> ou <em>shell_exec()</em> ne sont pas disponibles.','noMysql'=>'Les commandes <em>mysql</em> et/ou <em>mysqldump</em> n\'ont pas pu être trouvées.', 'backupVM' => 'La version source et la version cible sont les mêmes,donc aucune sauvegarde n\'est requise.','backupNA'=>'La configuration systèmes requise pour la création des sauvegardes n\'est pas remplie.', 'backupUD' => 'L\'option de sauvegarde a été dé-sélectionnée','backupOK'=>'La sauvegarde a été stockée dans %s.','restoreNA'=>'Aucun fichier de sauvegarde trouvé','restoreOK'=>'La base de données a été restaurée à partir de %s','noTemplates'=>'Il n\'y a pas de modèles personnalisés.', 'v3hint' => 'Procéder à la mise à jour de base de données de Contao 2 à Contao 3 grâce l\'outil d\'installation <a href="../install.php">Ouvrir l\'outil d\'installation</a>', 'php54' => 'Pour installer Contao 3.5+,vous avez besoin d\'au moins PHP 5.4.0 (version actuelle PHP %s).',);<?php return array('error'=>'Ina errur è capitada','admin'=>'Ti stos esser administratur per exequir quest script.','smh'=>'Ti stos activar il Safe Mode Hack per utilisar l\'actualisaziun directa(Live Update).', 'enterId' => 'Endatescha p.p.tia <a href="https://update.contao.org" target="_blank">ID per l\'actualisaziun directa</a>.','target'=>'Versiun da destinaziun','curver'=>'Ti has actualmain Contao %s.','installed'=>'(installà)','recommended'=>'(recummandà)','run'=>'Cumenzar l\'actualisaziun', 'emptyLuid' => 'Endatescha tia adressa da l\'actualisaziun directa','noselect'=>'Tscherna la versiun destinada','uptodate'=>'Questa installaziun da Contao è gia actuala.','connect'=>'Impussibel da connectar cun il server d\'actualisaziun', 'statcode' => 'Da dumonda ha returnà il code da status %s', 'continue' => 'Cuntinuar', 'beLogin' => 'Turnar al back-end', 'comment' => 'Commentari', 'notes' => 'Notizias da publicaziun', 'toggle' => 'Mussar las versiuns antiquadas', 'stable' => 'Versiun actuala', 'legacy' => 'Versiun antiquada', 'noteTitle' => 'Legia l\'annunzia da publicaziun','tooOld'=>'Ti dovras almain Contao 2.5.0 per pudair utilisar l\'actualisaziun directa(Live Update).', 'moreInfo' => 'Ulteriuras infurmaziuns', 'invalidVers' => 'Numer da versiun nunvalaivel', 'unsupported' => 'Versiun da Contao betg sustegnida', 'missingArgs' => 'La versiun da destinaziun manca.', 'missingFile' => 'La glista da datotecas manca.Cumenza ina nova dumonda.', 'missingZip' => 'L\'archiv dad actualisar manca. Cumenza ina nova dumonda','step'=>'Pass','protocol'=>'Installaziun d\'actualisaziuns', 'stats' => 'Chattà %s datotecas mancantas e %s datotecas differentas', 'step_1' => 'Controllar las datotecas d\'installaziun','step_2'=>'Crear ina copia da segirezza da la banca da datas','step_3'=>'Telechargiar l\'archiv da l\'actualisaziun','step_4'=>'Extrair l\'archiv da l\'actualisaziun','step_5'=>'Restaurar la copia da segirezza da la banca da datas','step_6'=>'Controllar anc ina giada las datotecas d\'installaziun', 'step_6a' => 'Elavurar las datotecas "runonce"', 'step_7' => 'Datotecas da template persunalisadas', 'step_7_txt' => 'Mussa la differenza tranter tias midadas(verd) e la versiun originala(cotschen).', 'step_8' => 'Datotecas independentas', 'step_8_txt' => 'Mussa ina glista da las datotecas che na tutgan betg tar Contao.', 'noUnrelated' => 'Chattà naginas datotecas betg dependentas', 'purge' => 'Schubregiar las datotecas tschernidas', 'downloaded' => 'L\'archiv è vegnì telechargià cun success.','extracted'=>'%s datotecas èn vegnidas extratgas.','updated'=>'Las datotecas da l\'installaziun èn vegnidas actualisadas cun success.', 'failed' => 'Questa installaziun da Contao na pudeva <b>betg</b> vegnir actualisada.Basegna Contao il safe-mode-hack ed has ti configurà correctamain quel?', 'completed' => 'L\'actualisaziun directa (Live Update) è succedida cun success. Questa actualisaziun è ussa actuala.','dbBackup'=>'Copia da segirezza da la banca da datas','backupOk'=>'Cumonds: %s e %s','noExec'=>'Las funcziuns da PHP <em>exec()</em> u <em>shell_exec()</em> na stattan betg a disposiziun','noMysql'=>'Ils cumonds <em>mysql</em> ed/u <em>mysqldump</em> na pudevan betg vegnir chattads.','backupVM'=>'La versiun da partenza e la versiun da destinaziun èn identicas. Ina copia da segirezza n\'è betg necessaria.', 'backupNA' => 'Las pretensiuns per il sistem per crear copias da segirezza n\'èn betg dadas.','backupUD'=>'L\'opziun per far copias da segirezza è vegnida deselectada', 'backupOK' => 'La copia da segirezza è vegnida memorisada en %s.', 'restoreNA' => 'Chattà nagina copia da segirezza correspundenta', 'restoreOK' => 'La banca da datas è vegnida restaurada da %s', 'noTemplates' => 'I n\'existan nagins templates persunalisads.','v3hint'=>'Cuntinuescha cun l\'utensil d\'installaziun per l\'actualisaziun da la banca da datas da Contao 2 sin Contao 3.<a href="../install.php">Avrir l\'utensil d\'installaziun</a>', 'php54' => 'Per installar Contao 3.5+ dovras ti almain PHP 5.4.0(ti has PHP %s).',);<?php return array('error'=>'Ha ocurrido un error','admin'=>'Tiene que ser administrador para ejecutar este script.','smh'=>'Necesita activar el Safe Mode Hack para utilizar el Live Update.','enterId'=>'Por favor introduzca su <a href="https://update.contao.org" target="_blank">ID Live Update</a>.','target'=>'Versión objetivo','curver'=>'Actualmente tiene Contao %s.','installed'=>'(instalado)','recommended'=>'(recomendado)','run'=>'Iniciar actualización','emptyLuid'=>'Por favor introduzca su ID del Live Update','noselect'=>'Por favor seleccione la versión destino','uptodate'=>'Su instalación de Contao está actualizada.','connect'=>'No se ha podido conectar al servidor Live Update','statcode'=>'La petición ha devuelto el código %s','continue'=>'Continuar','beLogin'=>'Volver al Back End','comment'=>'Comentarios','notes'=>'Release notes','toggle'=>'Mostrar versiones anteriores','stable'=>'Versión actual','legacy'=>'Versión obsoleta','noteTitle'=>'Lea el anuncio de lanzamiento','tooOld'=>'Necesita por lo menos Contao 2.5.0 para usar Live Update.','moreInfo'=>'Más información','invalidVers'=>'Número de versión inválido','unsupported'=>'Versión de Contao no soportada.','missingArgs'=>'No se encuentra la versión objetivo.','missingFile'=>'Listado de ficheros no encontrado. Por favor inicie una nueva petición.','missingZip'=>'No se encuentra el archivo de actualizaciones. Por favor inicie una nueva petición.','step'=>'Paso','protocol'=>'Actualizar instalación','stats'=>'Ficheros encontrados %s perdidos y %s diferentes.','step_1'=>'Verificando los ficheros de instalación','step_2'=>'Creando una copia de seguridad de base de datos','step_3'=>'Descargando el archivo de actualización','step_4'=>'Extrayendo el archivo de actualización','step_5'=>'Restaurando la copia de seguridad de base de datos','step_6'=>'Re-verificando los ficheros de instalación','step_6a'=>'Procesando los ficheros "runonce"','step_7'=>'Ficheros de plantilla personalizada','step_7_txt'=>'Muestra las diferencias entre sus cambios (verde) y los de la versión original (rojo).','step_8'=>'Ficheros sin relacionar','step_8_txt'=>'Muestra un listado de ficheros que no pertenecen a la distribución del núcleo de Contao.','noUnrelated'=>'No se han encontrado ficheros sin relación.','purge'=>'Purgar ficheros selecionados','downloaded'=>'El archivo se ha descargado satisfactoriamente.','extracted'=>'%s archivos han sido extraídos.','updated'=>'Los ficheros de instalación han sido actualizados satisfactoriamente.','failed'=>'Su instalación podría <b>no</b> estar actualizada. Está hecho el Safe Mode Hack en su servidor y configurado correctamente?','completed'=>'El Live Update se ha completado satisfactoriamente. Su instalación está actualizada.','dbBackup'=>'Copia de seguridad de base de datos','backupOk'=>'Comandos: %s y %s','noExec'=>'Las funciones PHP <em>exec()</em> o <em>shell_exec()</em> no están disponibles.','noMysql'=>'Los comandos <em>mysql</em> y/o <em>mysqldump</em> no han podido ser encontrados.','backupVM'=>'La versión fuente y la de destino son las mismas, no es necesaria una copia de seguridad.','backupNA'=>'Los requerimientos del sistema para crear copias de seguridad no se conocen.','backupUD'=>'La opción de copia de seguridad ha sido deseleccionada','backupOK'=>'La copia de seguridad ha sido almacenada en %s.','restoreNA'=>'No se han encontrado copias de seguridad','restoreOK'=>'La base de datos ha sido restaurada desde %s','noTemplates'=>'No hay plantillas personalizadas.','v3hint'=>'Por favor continue con la herramienta de instalación para la actualización de la base de datos desde Contao 2 a Contao 3! <a href="../install.php">Abrir la herramienta de instalación</a>','php54'=>'Para instalar Contao 3.5+, necesita al menos PHP 5.4.0 (tienes PHP %s).',);<?php return array('error'=>'Prišlo je do napake','admin'=>'Potrebno je biti administrator, da zaženeto to skripto.','smh'=>'Potrebno je vklopiti Safe Mode Hack, da bi uporabili Live Update.','enterId'=>'Vnesite vaš <a href="https://update.contao.org" target="_blank">Live Update ID</a>.','target'=>'Ciljna različica','curver'=>'Trenutno je nameščen Contao %s.','installed'=>'(nameščen)','recommended'=>'(priporočen)','run'=>'Zaženite posodobitev','emptyLuid'=>'Prosimo vnesite vaš Live Update ID','noselect'=>'Prosimo izberite želeno ciljno verzijo','uptodate'=>'Vaša Contao namestitev je posodobljena.','connect'=>'Ni bilo mogoče vspostaviti povezave z Live Update strežnikom','statcode'=>'Zahteva je vrnila status kodo %s','continue'=>'Nadaljuj','beLogin'=>'Nazaj na vmesnik','comment'=>'Komentar','notes'=>'Podrobnosti izdaje','toggle'=>'Prikaži obstoječe različice','stable'=>'Trenutna različica','legacy'=>'Zastarela različica','noteTitle'=>'Preberite obvestilo objave','tooOld'=>'Potrebujete najmanj Contao 2.5.0, da bi uporabili Live Update.','moreInfo'=>'Več informacij','invalidVers'=>'Neveljavna številka različice','unsupported'=>'Nepodprta Contao različica','missingArgs'=>'Ciljna različica manjka','missingFile'=>'Seznam datotek manjka. Prosimo poženite novo zahtevo.','missingZip'=>'Posodobitveni arhiv manjka. Prosimo poženite novo zahtevo.','step'=>'Korak','protocol'=>'Posodobite namestitev','stats'=>'Najdeno %s manjkajočih in %s različnih datotek.','step_1'=>'Preverite namestitvene datoteke','step_2'=>'Ustvarite varnostno kopijo podatkovne baze','step_3'=>'Prenašanje posodobitvenega arhiva','step_4'=>'Razširjanje posodobitvenega arhiva','step_5'=>'Obnavljanje varnostne kopije podatkovne baze','step_6'=>'Preverjanje namestitvenih datotek','step_6a'=>'Obdelava "runonce" datotek','step_7'=>'Datoteke predlog po meri','step_7_txt'=>'Prikaže razlike med spremenjenimi (zelena) in izvirnimi različicami (rdeča).','step_8'=>'Nepovezane datoteke','step_8_txt'=>'Prikaže seznam datotek, katere ne pripadajo distribuciji Contao jedra.','noUnrelated'=>'Ni nepovezanih datotek.','purge'=>'Čiščenje izbranih datotek','downloaded'=>'Arhiv je bil uspešno prenešen.','extracted'=>'%s datotek je bilo razširjenih.','updated'=>'Namestitvene datoteke so bile uspešno posodobljene.','failed'=>'Vaše namestitve <b>ni</b> bilo mogoče posodobiti. Contao potrebuje pravilno nastavitev Safe Mode Hack na strežniku.','completed'=>'Live Update se je uspešno zaključil. Vaša namestitev je posodobljena.','dbBackup'=>'Varnostna kopija podatkovne baze','backupOk'=>'Ukazi: %s in %s','noExec'=>'PHP funkciji <em>exec()</em> ali <em>shell_exec()</em> nista na voljo.','noMysql'=>'Ukaza <em>mysql</em> in/ali <em>mysqldump</em> ni bilo mogoče najti.','backupVM'=>'Izvirnik in ciljna različica sta enaki, zato varnostna kopija ni potrebna.','backupNA'=>'Sistemske zahteve za ustvarjanje varnostnih kopij niso zadoščene.','backupUD'=>'Možnost varnostne kopije ni bila izbrana.','backupOK'=>'Varnostna kopija je bila shranjena v %s.','restoreNA'=>'Ustrezna varnostna kopija ni bila najdena','restoreOK'=>'Podatkovna baza je bila obnovljena iz %s','noTemplates'=>'Predloge po meri ne obstajajo.','v3hint'=>'Prosimo nadaljuje na namestitveno orodje za posodobitev podatkovne baze iz Contao 2 v Contao 3! <a href="../install.php">Odprite namestitveno orodje</a>','php54'=>'Za namestitev Contao 3.5+ potrebujete najmanj PHP 5.4.0 (trenutno imate PHP %s).',);<?php return array('error'=>'Es ist ein Fehler aufgetreten','admin'=>'Sie müssen ein Administrator sein, um dieses Skript auszuführen.','smh'=>'Sie müssen den Safe-Mode-Hack aktivieren, um das Live Update zu nutzen.','enterId'=>'Bitte geben Sie Ihre <a href="https://update.contao.org" target="_blank">Live-Update-ID</a> ein.','target'=>'Zielversion','curver'=>'Sie verwenden momentan Contao %s.','installed'=>' (installiert)','recommended'=>' (empfohlen)','run'=>'Update starten','emptyLuid'=>'Bitte geben Sie Ihre Live Update ID ein','noselect'=>'Bitte wählen Sie die Zielversion','uptodate'=>'Ihre Contao-Installation ist bereits aktuell.','connect'=>'Keine Verbindung zum Live Update-Server möglich','statcode'=>'Die Anfrage hat den Statuscode %s zurückgegeben','continue'=>'Weiter','beLogin'=>'Zurück zum Backend','comment'=>'Kommentar','notes'=>'Release-Hinweise','toggle'=>'Veraltete Versionen anzeigen','stable'=>'Aktuelle Version','legacy'=>'Veraltete Version','noteTitle'=>'Die Release-Ankündigung lesen','tooOld'=>'Sie benötigen mindestens Contao 2.5.0, um das Live Update nutzen zu können.','moreInfo'=>'Weitere Informationen','invalidVers'=>'Ungültige Versionsnummer','unsupported'=>'Nicht unterstützte Contao-Version.','missingArgs'=>'Die Zielversion wurde nicht angegeben.','missingFile'=>'Die Dateiliste fehlt. Bitte starten Sie eine neue Anfrage.','missingZip'=>'Das Update-Archiv fehlt. Bitte starten Sie eine neue Anfrage.','step'=>'Schritt','protocol'=>'Installation aktualisieren','stats'=>'%s fehlende und %s unterschiedliche Dateien gefunden.','step_1'=>'Prüfung der Dateien der Installation','step_2'=>'Erstellen des Datenbank-Backups','step_3'=>'Herunterladen des Update-Archivs','step_4'=>'Entpacken des Update-Archivs','step_5'=>'Wiederherstellen des Datenbank-Backups','step_6'=>'Nochmalige Prüfung der Dateien der Installation','step_6a'=>'Verarbeiten der "runonce"-Dateien','step_7'=>'Angepasste Template-Dateien','step_7_txt'=>'Zeigt die Unterschiede zwischen Ihren Änderungen (grün) und der Originalversion (rot).','step_8'=>'Distributionsfremde Dateien','step_8_txt'=>'Zeigt eine Liste von Dateien, die nicht zur Contao Core-Distribution gehören.','noUnrelated'=>'Keine distributionsfremden Dateien gefunden.','purge'=>'Ausgewählte Dateien löschen','downloaded'=>'Das Archiv wurde erfolgreich heruntergeladen.','extracted'=>'%s Dateien wurden extrahiert.','updated'=>'Die Installationsdateien wurden erfolgreich aktualisiert.','failed'=>'Ihre Installation konnte <b>nicht</b> vollständig aktualisiert werden. Benötigt Contao auf Ihrem Server den Safe-Mode-Hack und haben Sie diesen korrekt konfiguriert?','completed'=>'Das Live Update wurde erfolgreich abgeschlossen. Ihre Installation ist aktuell.','dbBackup'=>'Datenbank-Backup','backupOk'=>'Kommandos: %s und %s','noExec'=>'Die PHP-Funktionen <em>exec()</em> oder <em>shell_exec()</em> sind nicht verfügbar.','noMysql'=>'Die Kommandos <em>mysql</em> und/oder <em>mysqldump</em> wurden nicht gefunden.','backupVM'=>'Identische Quell- und Zielversion, daher ist kein Backup notwendig.','backupNA'=>'Die Backup-Systemvoraussetzungen sind nicht erfüllt.','backupUD'=>'Die Backup-Option wurde abgewählt','backupOK'=>'Das Backup wurde in der Datei %s gespeichert.','restoreNA'=>'Keine passende Backup-Datei gefunden','restoreOK'=>'Die Datenbank wurde aus der Datei %s wiederhergestellt.','noTemplates'=>'Es wurden keine angepassten Template-Dateien gefunden.','v3hint'=>'Bitte verwenden Sie das Installtool für das Datenbank-Update von Contao 2 auf Contao 3! <a href="../install.php">Das Installtool öffnen</a>','php54'=>'Für Contao 3.5+ benötigen Sie mindestens PHP 5.4.0 (Sie haben PHP %s).',);<?php return array('error'=>'Si è verificato un errore','admin'=>'Occorre essere amministratore per poter eseguire questo script.','smh'=>'È necessario attivare il Safe Mode Hack per utilizzare il Live Update.','enterId'=>'Inserire il proprio <a href="https://update.contao.org" target="_blank">Live Update ID</a>.','target'=>'Aggiorna alla versione','curver'=>'Attualmente è installato Contao %s.','installed'=>'(installato)','recommended'=>'(raccomandato)','run'=>'Avvia aggiornamento','emptyLuid'=>'Inserisci il Live update ID','noselect'=>'Seleziona la versione alla quale vuoi fare l\'aggiornamento', 'uptodate' => 'La tua versione di Contao è già aggiornata', 'connect' => 'Non sono in grado di collegarmi al Server di Live Update', 'statcode' => 'La richiesta ha restituito il codice di stato %s', 'continue' => 'Continua', 'beLogin' => 'Ritorna al backend', 'comment' => 'Commento', 'notes' => 'Note sulla release', 'toggle' => 'Visualizza versioni precedenti', 'stable' => 'Versione corrente', 'legacy' => 'Versioni obsolete', 'noteTitle' => 'Leggi gli annunci sulla release', 'tooOld' => 'È necessario almeno Contao 2.5.0 per utilizzare il Live Update.', 'moreInfo' => 'Maggiori informazioni', 'invalidVers' => 'Numero di versione non valido', 'unsupported' => 'Versione Contao non supportata.', 'missingArgs' => 'Versione di destinazione non trovata', 'missingFile' => 'La lista dei file è mancante.Occorre eseguire una nuova richiesta.', 'missingZip' => 'L\'archivio di aggiornamento è mancante. Occorre eseguire una nuova richiesta.','step'=>'Step','protocol'=>'Aggiornamento installazione','stats'=>'Sono stati trovati %s file mancanti e %s file modificati.','step_1'=>'Controlla i file dell\'installazione', 'step_2' => 'Crea un backup del database', 'step_3' => 'È in corso il download dell\'archivio di aggiornamento ','step_4'=>'È in corso l\'estrazione dell\'archivio di aggiornamento','step_5'=>'È in corso il ripristino del database di backup','step_6'=>'È in corso un nuovo controllo del file di installazione','step_6a'=>'Elaborazione dei "runonce" files','step_7'=>'Template personalizzati','step_7_txt'=>'Mostra la differenza tra le parti modificate (in verde) e la versione originale (in rosso).','step_8'=>'File non collegati','step_8_txt'=>'Mostra l\'elenco di file che non appartengono alla distribuzione Core di Contao.', 'noUnrelated' => 'Non è stato trovato nessun file non collegato', 'purge' => 'Elimina i file selezionati', 'downloaded' => 'L\'archivio è stato scaricato correttamente.','extracted'=>'Sono stati estratti %s file.','updated'=>'I file di installazione sono stati aggiornati correttamente.','failed'=>'La tua installazione potrebbe <b>non</b> essere aggiornata correttamente. Contao richiede il Safe Mode Hack sul server e che questo sia configurato correttamente.','completed'=>'Il Live Update è stato completato correttamente. La tua installazione è aggiornata.','dbBackup'=>'Backup database','backupOk'=>'Comandi: %s e %s','noExec'=>'Le funzioni PHP <em>exec()</em> o <em>shell_exec()</em> non sono disponibili.','noMysql'=>'I comandi <em>mysql</em> e/o <em>mysqldump</em> non sono stati trovati.','backupVM'=>'La versione di partenza e quella di destinazione sono le stesse, non è necessario alcun backup.','backupNA'=>'I requisiti di sistema per la creazione del backup non sono soddistatti.','backupUD'=>'L\'opzione backup è stata deselezionata', 'backupOK' => 'Il backup è stato memorizzato in %s.', 'restoreNA' => 'Non è stato trovato nessun file di backup', 'restoreOK' => 'Il database è stato ripristinato in %s', 'noTemplates' => 'Non sono presenti template personalizzati.', 'v3hint' => 'E\' necessario procedere all\'installazione del tool per eseguire l\'aggiornamento del database di Contao dalla versione 2 alla versione 3! <a href="../install.php">Apri l\'install tool</a>', 'php54' => 'Per installare Contao 3.5+,occorre PHP 5.4.0(Sul server è installato PHP %s).',);<?php return array('error'=>'Došlo k chybě','admin'=>'Musíte být administrátorem, abyste mohli spustit tento program. ','smh'=>'Nejdřív je zapotřebí aktivovat tzv. Safe mode Hack, abyste mohli použít Live Update.','enterId'=>'Zadejte prosím <a href="https://update.contao.org" target="_blank">Vaše ID pro Live Update</a>.','target'=>'Cílová verze','curver'=>'Momentálně používáte Contao %s.','installed'=>'(nainstalováno)','recommended'=>'(doporučeno)','run'=>'Spustit aktualizaci','emptyLuid'=>'Zadejte vaše ID online aktualizace','noselect'=>'Zvolte prosím požadovanou verzi','uptodate'=>'Již používáte aktuální verzi Contaa. ','connect'=>'Nepodařilo se připojit k serveru Live Update','statcode'=>'Požadavek vrátil zprávu o stavu %s','continue'=>'Pokračovat','beLogin'=>'Vrátit se do backendu','comment'=>'Komentář','notes'=>'Poznámky k vydání','toggle'=>'Zobrazit starší verze','stable'=>'Aktuální verze','legacy'=>'Zastaralá verze','noteTitle'=>'Přečíst poznámky k vydání','tooOld'=>'Potřebujete přinejmenším Contao 2.5.0, abyste mohli použít Live Update.','moreInfo'=>'Více informací','invalidVers'=>'Neplatné číslo verze','unsupported'=>'Nepodporovaná verze Contaa.','missingArgs'=>'Cílová verze není dostupná.','missingFile'=>'Chybí seznam souborů. Spusťte prosím nový požadavek. ','missingZip'=>'Chybí archiv zálohy. Spusťte prosím nový požadavek.','step'=>'Krok','protocol'=>'Zaktualizovat instalaci','stats'=>'Bylo nalezeno %s chybějících a %s rozdílných souborů.','step_1'=>'Zkontrolovat soubory k nainstalování','step_2'=>'Zálohovat databázi','step_3'=>'Stahuje se zaktualizovaný archiv','step_4'=>'Rozbaluje se zaktualizovaný archiv','step_5'=>'Obnovuje se zálohoha databáze','step_6'=>'Kontrolují se nainstalované soubory','step_6a'=>'Spouštění souborů "runonce"','step_7'=>'Soubory vlastních předloh','step_7_txt'=>'Zobrazí rozdíly mezi Vámi provedenými změnami (zeleně) a originální verzí (červeně)','step_8'=>'Nesouvisející soubory','step_8_txt'=>'Zobrazí seznam souborů, které nepatří k základní instalaci Contaa.','noUnrelated'=>'Nebyly nalezeny žádné nepatřičné soubory.','purge'=>'Vyčistit vybrané soubory','downloaded'=>'Archiv byl úspěšně stažený.','extracted'=>'%s souborů bylo rozbaleno.','updated'=>'Instalační soubory byly úspěšně zaktualizovány.','failed'=>'Vaše instalace <b>nemohla</b> být dokončená. Contao vyžaduje tzv. Safe Mode Hack na Vašem serveru - nastavili jste ho dobře?','completed'=>'Live Update proběhl úspěšně. Používáte poslední verzi Contaa.','dbBackup'=>'Zálohovat databázi','backupOk'=>'Příkazy: %s a %s','noExec'=>'Funkce PHP <em>exec()</em> nebo <em>shell_exec()</em> nejsou k dispozici.','noMysql'=>'Příkazy <em>mysql</em> a/nebo <em>mysqldump</em> nešlo najít.','backupVM'=>'Zdrojová a cílová verze jsou totožné, proto není požadovaná žádná záloha.','backupNA'=>'Neproběhly systémové požadavky na vytvoření záloh.','backupUD'=>'Byla zrušena možnost zálohy. ','backupOK'=>'Záloha je uložená v %s.','restoreNA'=>'Nenašel se žádný odpovídající soubor zálohy.','restoreOK'=>'Databáze byla obnovena z %s','noTemplates'=>'Neexistují žádné vlastní předlohy.','v3hint'=>'Spusťte prosím instalační nástroj, abyste zaktualizovali databanku z Contaa 2 na Contao 3! <a href="../install.php">Spustit instalační nástroj</a>','php54'=>'Pro instalaci Contaa 3.5+ je zapotřebí nejméně PHP 5.4.0 (používáte PHP %s).',);<!DOCTYPE html><html lang="{language}"><head><meta charset="utf-8"><title>Contao Live Update</title><link rel="stylesheet" href="assets/css/basic.css"><link rel="stylesheet" href="assets/css/install.css"><link rel="stylesheet" href="assets/css/update.css"><!--[if lt IE 9]><script src="assets/js/html5.js"></script><![endif]--></head><body class="{agent}"><div id="header"><h1>Contao Open Source CMS</h1></div><div id="container"><div id="main"><h2>{h2}</h2><div class="outer"><ul id="tabs"><li><a href="index.php">{protocol}</a></li><li><a href="index.php?do=templates">{step_7}</a></li><li><a href="index.php?do=unrelated" class="active">{step_8}</a></li></ul><div id="t3" class="tab"><div id="o3" class="tl_formbody"><h3>{step_8}</h3><p>{step_8_txt}</p><form action="index.php?do=unrelated" class="tl_install_form" method="post">{form}</form></div></div></div><p id="go_to_login"><a href="../main.php">{beLogin}</a></p></div></div></body></html><!DOCTYPE html><html lang="{language}"><head><meta charset="utf-8"><title>Contao Live Update</title><link rel="stylesheet" href="assets/css/basic.css"><link rel="stylesheet" href="assets/css/install.css"><link rel="stylesheet" href="assets/css/update.css"><!--[if lt IE 9]><script src="assets/js/html5.js"></script><![endif]--></head><body class="{agent}"><div id="header"><h1>Contao Open Source CMS</h1></div><div id="container"><div id="main"><h2>{h2}</h2><div class="outer"><ul id="tabs"><li><a href="index.php" class="active">{protocol}</a></li><li><a href="index.php?do=templates">{step_7}</a></li><li><a href="index.php?do=unrelated">{step_8}</a></li></ul><div id="t1" class="tab"><div id="o1" class="tl_formbody"></div></div></div><p id="go_to_login"><a href="../main.php">{beLogin}</a></p></div></div><script src="assets/js/mootools.js"></script><script src="assets/js/update.js"></script><script>LiveUpdate.process()</script></body></html><!DOCTYPE html><html lang="{language}"><head><meta charset="utf-8"><title>Contao Live Update</title><link rel="stylesheet" href="assets/css/basic.css"><link rel="stylesheet" href="assets/css/install.css"><link rel="stylesheet" href="assets/css/update.css"><!--[if lt IE 9]><script src="assets/js/html5.js"></script><![endif]--></head><body class="{agent}"><div id="header"><h1>Contao Open Source CMS</h1></div><div id="container"><div id="main"><h2>{h2}</h2><fieldset class="tl_tbox nolegend"><h3>{headline}</h3><p class="tl_error">{text}</p></fieldset><p id="go_to_login"><a href="../main.php">{beLogin}</a></p></div></div></body></html><!DOCTYPE html><html lang="{language}"><head><meta charset="utf-8"><title>Contao Live Update</title><link rel="stylesheet" href="assets/css/basic.css"><link rel="stylesheet" href="assets/css/install.css"><link rel="stylesheet" href="assets/css/update.css"><!--[if lt IE 9]><script src="assets/js/html5.js"></script><![endif]--></head><body class="{agent}"><div id="header"><h1>Contao Open Source CMS</h1></div><div id="container"><div id="main"><h2>{h2}</h2><div class="outer"><ul id="tabs"><li><a href="index.php">{protocol}</a></li><li><a href="index.php?do=templates" class="active">{step_7}</a></li><li><a href="index.php?do=unrelated">{step_8}</a></li></ul><div id="t2" class="tab"><div id="o2" class="tl_formbody"><h3>{step_7}</h3><p>{step_7_txt}</p><div class="templates">{templates}</div></div></div></div><p id="go_to_login"><a href="../main.php">{beLogin}</a></p></div></div></body></html><!DOCTYPE html><html lang="{language}"><head><meta charset="utf-8"><title>Contao Live Update</title><link rel="stylesheet" href="assets/css/basic.css"><link rel="stylesheet" href="assets/css/install.css"><link rel="stylesheet" href="assets/css/update.css"><!--[if lt IE 9]><script src="assets/js/html5.js"></script><![endif]--></head><body class="{agent}"><div id="header"><h1>Contao Open Source CMS</h1></div><div id="container"><div id="main"><h2>{h2}</h2><div class="outer"><ul id="tabs"><li><a href="index.php" class="active">{protocol}</a></li><li><a href="index.php?do=templates">{step_7}</a></li><li><a href="index.php?do=unrelated">{step_8}</a></li></ul><div id="t1" class="tab"><div id="o1" class="tl_formbody"><form action="index.php" class="tl_install_form" method="post"><fieldset class="tl_tbox nolegend"><div class="tl_formbody"><input type="hidden" name="REQUEST_TOKEN" value="{token}"><h3>Live Update ID</h3>{emptyLuid}<input type="text" name="luid" class="tl_text" value="{luid}"><p class="tl_help">{luidHelp}</p><div class="tl_checkbox_single_container"><input type="hidden" name="backup" value=""><label>{dbBCheckbox} {dbBackup}</label></div><p class="tl_help">{dbBCommands}</p><h3>{target}</h3>{noselect}{versions}<p class="tl_help">{curver}</p></div><div class="tl_formbody_submit"><div class="tl_submit_container"><input type="submit" class="tl_submit" value="{run}"></div></div></fieldset></form></div></div></div><p id="go_to_login"><a href="../main.php">{beLogin}</a></p></div></div><script src="assets/js/mootools.js"></script><script src="assets/js/update.js"></script><script>LiveUpdate.toggle()</script></body></html>#container h3{border:0;margin:0}#container h3 img{vertical-align:bottom;cursor:pointer}#container h3.backup{padding-bottom:0}.outer{margin:0 18px}a:hover{color:#666966;text-decoration:underline}.hide{display:none}#file-list{padding:0;margin-top:1.5em;list-style:circle outside}#file-list li{margin-left:1em}.mt1{margin-top:1em !important}fieldset{margin:0;padding:0;border:0}fieldset.tl_tbox{margin:0;padding-top:0;border-top:1px solid #ddd}.tl_formbody p{margin:0}.tl_formbody,.tl_formbody_submit{margin:0}.tl_radio{margin-top:2px;margin-left:2px}td label{vertical-align:1px}.tl_help,.tl_help a{color:#a3a3a3;font-size:10px}.tl_help a:hover{text-decoration:underline}table{border-spacing:0;border-collapse:collapse;margin-bottom:3px}th,td{text-align:left;padding:3px 9px 4px}thead th{background:#ddd;border-top:1px solid #ccc;border-bottom:1px solid #ccc}tbody th,tfoot td{background:#f6f6f6;border-bottom:1px solid #e6e6e6}tbody td{border-bottom:1px solid #ececec}tfoot td{text-align:right;padding:2px 9px 3px}tfoot td .tl_checkbox{margin-left:3px !important;margin-right:0 !important}tr.note th{padding-top:9px;padding-bottom:9px;background-color:#ffc;font-weight:normal}tr.disabled{opacity:.5}.update_hint{padding:12px;border:1px solid #fc0;border-radius:3px;margin:1em 0;font-size:15px;line-height:1.5;position:relative;background:#ffc}.update_hint a{display:block;position:absolute;right:0;bottom:-44px;color:#bbb;background:url("../images/login.gif") no-repeat left center;padding:3px 0 3px 20px}#tabs{margin-top:2em;padding:0 0 0 12px;border-bottom:1px solid #ddd}#tabs li{display:inline-block}#tabs a{display:block;margin-right:6px;padding:4px 12px;background:#f6f6f6;border:1px solid #ddd;border-bottom:0;border-top-left-radius:3px;border-top-right-radius:3px;color:#777;text-decoration:none}#tabs a:hover,#tabs a.active{background:#eee;color:#666966}#tabs a.active{margin-bottom:-1px;background:#fff;border-bottom:1px solid #fff}#container h4{margin-top:18px;font-weight:bold}.templates{width:720px}.templates .change{margin:12px 0 15px;padding:9px 6px;border:1px solid #ddd;background:#fcfcfc;border-radius:3px}.templates .change *{font-family:Courier,monospace;font-size:12px}.templates .replace.left,.templates .delete.left{background:#fdd}.templates .replace.right,.templates .insert.right{background:#dfd}.templates .replace ins{color:#060;background:#bfb}.templates .replace del{color:#a00;background:#fbb}.templates ins,.templates del{text-decoration:none}.templates ul{margin:0;padding:0}.templates li{margin:0;padding:2px 6px 1px}body{background:#f5f5f5 url("../images/hbg.jpg") repeat-x}#header{width:756px;margin:18px auto 0;padding:1px;background:#fff;border:1px solid #bbb;border-bottom:0;border-radius:3px 3px 0 0}#header h1{margin:0;padding:4px 8px 6px;color:#fff;border-radius:3px 3px 0 0}#container{width:760px;margin:0 auto;padding:0 0 18px}#main{width:756px;padding:1px;background:#fff;border:1px solid #bbb;border-top:0;border-radius:0 0 3px 3px;box-shadow:0 3px 6px #ccc}#container h2{margin:16px 18px 0;padding:8px 0 7px 36px;background:url("../images/install.gif") no-repeat left center;font-size:14px;font-size:.875rem;color:#8ab858}#container h2.important{margin:16px 18px 0;padding:7px 0 8px 36px;background:url("../images/important.gif") no-repeat left center;font-size:14px;font-size:.875rem;font-weight:bold;color:#c33}#container h3{margin:0;padding:18px 0 3px;font-size:12px;font-size:.75rem;font-weight:bold}#container h4{margin:12px 0 1px;padding:0;font-size:11px;font-size:.6875rem;font-weight:normal}p{margin:0 0 12px;padding:0;line-height:16px}ul{margin:12px 0;padding:0 0 0 48px}li{line-height:16px}.code_old{margin:9px 18px;padding:6px 6px 7px;border:1px solid #c00;background:#fdd}.code_new{margin:9px 18px;padding:6px 6px 7px;border:1px solid #0a0;background:#dfd}#sql_wrapper{max-height:300px;overflow:auto;border:1px solid #ddd;background:#fcfcfc;padding:9px}#sql_table{margin:-3px 0}#sql_table pre{white-space:pre-wrap}#sql_table .tl_checkbox{margin-top:3px}.webkit #sql_table .tl_checkbox{margin-top:4px}.ie #sql_table .tl_checkbox{margin-top:-1px}#sql_table pre label{font-family:"Andale Mono",monospace}.mac #sql_table pre label{font-size:12px;font-size:.75rem}.tl_col_0{padding:6px 0 2px;font-weight:bold;color:#77ac45}.tl_col_1{vertical-align:top}.tl_col_2{padding:2px 0 3px 4px}.tl_error,.tl_confirm,.tl_info{margin:0;padding:1px 0 1px 20px}.tl_error{color:#c33;background:url("../images/error.gif") no-repeat left 1px}.tl_confirm{color:#77ac45;background:url("../images/ok.gif") no-repeat left 1px}.tl_info{color:#4b85ba;background:url("../images/show.gif") no-repeat 1px 1px}.tl_formbody .tl_error{margin:0}#go_to_login{margin:0 18px 14px 0;padding:0;text-align:right}#go_to_login a{padding:2px 0 3px 20px;background:url("../images/login.gif") no-repeat left center;color:#aaa}#license pre{height:400px;overflow:auto;margin:0;background:#f9f9f9;border:1px solid #aaa;padding:10px}.tl_formbody,.tl_formbody_submit{margin:0}.tl_submit_container{margin-top:18px}fieldset>div{margin-bottom:24px}fieldset.last>div{margin-bottom:0}fieldset.tl_tbox{margin-top:18px}fieldset.tl_tbox,fieldset.tl_box{margin-left:18px;margin-right:18px;padding:6px;border:1px solid #ddd;border-width:1px 0 0}fieldset.tl_tbox>legend,fieldset.tl_box>legend{margin-top:-1px;color:#77ac45;padding-left:18px;padding-right:3px;background:url("../images/palOpen.gif") left center no-repeat;cursor:pointer}fieldset.tl_tbox.nolegend{border:0;margin-top:0}fieldset.collapsed{padding-top:0;padding-bottom:12px;margin-bottom:0}fieldset.collapsed div{display:none !important}fieldset.collapsed>legend{background:url("../images/palCollapsed.gif") left center no-repeat}.tl_text{width:232px !important}.tl_select{width:238px !important}@media(max-width:767px){#header,#container{width:auto;margin-left:10px;margin-right:10px}#main{width:auto}#container h4{margin-top:6px}fieldset.tl_tbox,fieldset.tl_box{margin-left:12px;margin-right:12px}.tl_text,.tl_select{width:100% !important;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box}.tl_formbody,.tl_formbody_submit{position:relative}.tl_error,.tl_confirm,.tl_info{background-position:1px center}}html{font-size:100%;-webkit-text-size-adjust:100%}html,body,form,pre,figure,ul,li{margin:0;padding:0}img{border:0}ul,li{list-style:none}a,b,body,cite,div,em,h1,h2,h3,h4,h5,h6,i,label,legend,li,ol,p,strong,td,th,u,ul{font-family:Verdana,sans-serif}fieldset,form,input,optgroup,select,textarea{font-family:"Trebuchet MS",Verdana,sans-serif}a,body,div,label,legend,li,ol,p,td,th,ul,fieldset,form,input,optgroup,select,textarea{font-size:11px;font-size:.6875rem;color:#444}fieldset,form,input,optgroup,select,textarea{font-size:12px;font-size:.75rem}h1,h2,h3,h4,h5,h6{font-size:12px;font-size:.75rem;color:#444}table{border-spacing:0;border-collapse:collapse}th,td{padding:0;text-align:left}.tl_small{font-size:9px;font-size:.5625rem}.tl_small,.tl_gray{color:#999}.tl_green{color:#77ac45}.tl_red{color:#c33}.tl_blue{color:#4b85ba}.tl_orange{color:#f90}span.mandatory{color:#c33}a{color:#444;text-decoration:none}a:hover,a:focus,a:active{color:#77ac45}hr{height:1px;margin:18px 0;border:0;background:#ddd;color:#ddd}p{margin:0 0 12px;padding:0}.hidden{display:none}.clear{clear:both;height:.1px;line-height:.1px;font-size:.1px}.invisible{width:0;height:0;left:-1000px;top:-1000px;position:absolute;overflow:hidden;display:inline}optgroup{padding-top:3px;padding-bottom:3px;font-style:normal;background:#fff}fieldset.tl_checkbox_container,fieldset.tl_radio_container{border:0;margin:15px 0 1px;padding:0}fieldset.tl_checkbox_container{line-height:14px}fieldset.tl_checkbox_container legend,fieldset.tl_radio_container legend{font-weight:bold;margin:0;padding:0}fieldset.checkbox_container,fieldset.radio_container{border:0;margin:0;padding:0}.tl_text,.tl_text_2,.tl_text_3,.tl_text_4,.tl_textarea{margin:1px 0}.tl_text{width:312px}.tl_text_2{width:150px}.tl_text_3{width:97px}.tl_text_4{width:70px}.tl_textarea{width:676px;height:240px}.tl_text_unit{margin:1px 0;width:248px}.tl_text_trbl{margin:1px 0;width:53px}.tl_text_interval{margin:1px 0;width:154px}.tl_text,.tl_text_2,.tl_text_3,.tl_text_4,.tl_textarea,.tl_text_unit,.tl_text_trbl,.tl_text_interval{border:1px solid #aaa;padding:2px 3px;border-radius:3px}.mac .tl_text,.mac .tl_text_2,.mac .tl_text_3,.mac .tl_text_4,.mac .tl_textarea,.mac .tl_text_unit,.mac .tl_text_trbl,.mac .tl_text_interval{padding:3px}.tl_text:focus,.tl_text_2:focus,.tl_text_3:focus,.tl_text_4:focus,.tl_textarea:focus,.tl_text_unit:focus,.tl_text_trbl:focus,.tl_text_interval:focus{background-color:#ebfdd7}.tl_text[disabled],.tl_text_2[disabled],.tl_text_3[disabled],.tl_text_4[disabled],.tl_textarea[disabled],.tl_text_unit[disabled],.tl_text_trbl[disabled],.tl_text_interval[disabled],.tl_text[readonly],.tl_text_2[readonly],.tl_text_3[readonly],.tl_text_4[readonly],.tl_textarea[readonly],.tl_text_unit[readonly],.tl_text_trbl[readonly],.tl_text_interval[readonly]{color:#bbb;background-color:#f9f9f9;border:1px solid #c8c8c8}pre,.tl_textarea.monospace{font-family:Courier,monospace;font-size:12px;font-size:.75rem}.tl_textarea.monospace:focus{background:0}.tl_select,.tl_mselect,.tl_select_column{margin:1px 0}.tl_box .tl_select,.tl_tbox .tl_select,.tl_box .tl_mselect,.tl_tbox .tl_mselect{width:320px}.tl_select_column{width:140px}.tl_select_unit{margin:1px 0;width:60px}.tl_select_interval{margin:1px 0;width:154px}.tl_select,.tl_mselect,.tl_select_column,.tl_select_unit,.tl_select_interval{border:1px solid #aaa;padding:1px;border-radius:3px}.mac .tl_select,.mac .tl_mselect,.mac .tl_select_column,.mac .tl_select_unit,.mac .tl_select_interval{padding:2px 1px}.tl_select[disabled],.tl_mselect[disabled],.tl_select_column[disabled],.tl_select_unit[disabled],.tl_select_interval[disabled]{color:#bbb;background-color:#f9f9f9;border:1px solid #c8c8c8}.tl_checkbox{margin:1px 3px 0 0;vertical-align:bottom}.mac .tl_checkbox{margin:0 3px 0 0;position:relative;top:-1px}.mac .tl_checkbox_single_container .tl_checkbox{top:0}.ie .tl_checkbox{margin:-3px 0 -1px -2px;position:relative;top:1px;vertical-align:middle}.ie .tl_checkbox_single_container .tl_checkbox{top:0}.tl_tree_checkbox{margin:0 3px 0 0}.mac .tl_tree_checkbox{margin:2px 3px 0 0}.tl_checkbox_single_container{margin:16px 0 1px}.tl_checkbox_single_container label{font-weight:bold}.tl_checkbox_container label{display:block;margin:-14px 0;padding-left:20px}.tl_checkbox_container label:last-child{margin-bottom:0}.checkbox_toggler{font-weight:bold}.checkbox_toggler_first{font-weight:bold;margin-top:3px}.checkbox_toggler img,.checkbox_toggler_first img{vertical-align:top;position:relative;top:-2px;margin-right:3px}.checkbox_options{margin:0 0 6px 21px !important}.tl_radio{margin:1px 3px 0 0;vertical-align:bottom}.win .tl_radio{margin:1px 3px 3px 0}.tl_tree_radio{margin:0 3px 1px 0;vertical-align:middle}.safari .tl_radio,.safari .tl_tree_radio{margin-left:1px}.tl_radio_table{margin:2px 0 1px}.tl_radio_table td{padding:0 24px 1px 0}.tl_radio_table img,.tl_radio_table input{vertical-align:middle}.tl_upload_field{margin:1px 0}.tl_submit{padding:5px 12px 5px 13px;border:1px solid #aaa;border-radius:3px;color:#555;cursor:pointer;line-height:1;text-shadow:1px 1px 0 #eee;background:#eee;background-image:-moz-linear-gradient(bottom,#ccc 0,#eee 60%);background-image:-webkit-linear-gradient(bottom,#ccc 0,#eee 60%);background-image:-o-linear-gradient(bottom,#ccc 0,#eee 60%);background-image:-ms-linear-gradient(bottom,#ccc 0,#eee 60%);background-image:linear-gradient(to top,#ccc 0,#eee 60%)}a.tl_submit{font-family:"Trebuchet MS",Verdana,sans-serif;font-size:12px;font-size:.75rem;display:inline-block}a.tl_submit,a.tl_submit:hover{color:#555}.firefox input.tl_submit{padding:2px 12px 2px 13px}.opera input.tl_submit{padding:4px 12px 4px 13px}.tl_submit:focus,.tl_submit:hover{box-shadow:0 0 3px #aaa}.tl_submit:active{color:#bbb;box-shadow:0 0 6px #999}.tl_submit:disabled{cursor:default;background:#ddd;text-shadow:none;color:#999;box-shadow:none}.clr{clear:both;display:table;width:100%}.w50{width:50%;float:left;height:72px}.long{width:100%}.w50 .tl_help{margin-right:24px}.wizard .tl_text{width:288px}.wizard .tl_text_2{width:138px}.long .tl_text{width:663px}.long .tl_select{width:670px}.m12{margin:12px 0}.webkit .m12{margin:13px 0 11px}.cbx{height:48px}.inline div{display:inline}.autoheight{height:auto}.tl_tip{height:13px;overflow:hidden;cursor:pointer}.tip-wrap{z-index:99}.tip{max-width:320px;padding:3px 6px 4px;border-radius:3px;box-shadow:1px 1px 3px #666;background:#666;background-image:-moz-linear-gradient(bottom,#333 0,#666 80%);background-image:-webkit-linear-gradient(bottom,#333 0,#666 80%);background-image:-o-linear-gradient(bottom,#333 0,#666 80%);background-image:-ms-linear-gradient(bottom,#333 0,#666 80%);background-image:linear-gradient(to top,#333 0,#666 80%)}.tip div{line-height:1.3}.tip div,.tip a{color:#fff}.tip-top{height:6px;position:absolute;top:-13px;border-left:7px solid transparent;border-right:7px solid transparent;border-bottom:7px solid #666}#header h1,#tl_navigation h1,h1.main_headline{background:#909390;background-image:-moz-linear-gradient(top,#909390,#b3b6b3);background-image:-webkit-linear-gradient(top,#909390,#b3b6b3);background-image:-o-linear-gradient(top,#909390,#b3b6b3);background-image:-ms-linear-gradient(top,#909390,#b3b6b3);background-image:linear-gradient(to bottom,#909390,#b3b6b3)}@media(min-width:1200px){.tl_text{width:404px}.tl_text_2{width:196px}.tl_text_3{width:127px}.tl_text_4{width:92px}.tl_textarea{width:854px}.tl_text_unit{width:340px}.tl_text_trbl{width:76px}.tl_text_interval,.tl_select_interval{width:200px}.tl_box .tl_select,.tl_tbox .tl_select,.tl_box .tl_mselect,.tl_tbox .tl_mselect{width:412px}.wizard .tl_text{width:380px}.wizard .tl_text_2{width:184px}.long .tl_text{width:845px}.long .tl_select{width:853px}.tip{max-width:410px}}@media(max-width:767px){.w50{float:none;width:auto}.cbx{height:32px}img{max-width:100%;height:auto}.ie8 img{width:auto}a img{max-width:none}.tl_text,.long .tl_text,.tl_textarea,.tl_box .tl_select,.tl_tbox .tl_select,.tl_box .tl_mselect,.tl_tbox .tl_mselect,.long .tl_select{width:100%}.tl_text_2{width:-webkit-calc(50% - 2px);width:calc(50% - 2px)}.tl_text_3{width:-webkit-calc(33% - 2px);width:calc(33% - 2px)}.tl_text_4{width:-webkit-calc(25% - 3px);width:calc(25% - 3px)}.tl_text_unit{width:-webkit-calc(100% - 64px);width:calc(100% - 64px)}.tl_text_trbl{width:-webkit-calc(25% - 19px);width:calc(25% - 19px)}.tl_text_interval,.tl_select_interval{width:-webkit-calc(50% - 2px);width:calc(50% - 2px)}.wizard .tl_text{width:-webkit-calc(100% - 24px);width:calc(100% - 24px)}.wizard .tl_text_2{width:-webkit-calc(50% - 14px);width:calc(50% - 14px)}.tip{max-width:220px}.tl_text,.tl_text_2,.tl_text_3,.tl_text_4,.tl_textarea,.tl_text_unit,.tl_text_trbl,.tl_text_interval,.tl_select,.tl_mselect,.tl_select_interval{-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box}.tl_version_panel .tl_select{width:44%}.tl_select_column{width:66px}}GIF89a    追赲⵲洱஫ѩޥ࢞䠝Ϧޛۜ⛘қћڔ܊ڈۈytvstprnee`_`_ZZ]]]\[[ZZXXTUUVVV\YUUSTRTTSQQRRQQVQPPOOUQNNMMLMMMKKHIIJOLJEFFCDDDABC@B>;<><?<<=98?:<<76995543445732:661/.3/+)*(.(%#*%"# 
        ! } ,       }  .WZZX- h];;cR^Y5GME`F
%sOJ:33:NKn
Qf+''#'/b0j_ aIgi",d>	1zUB6227DPv* {xS?88=LptLSƊ.qt(%/ě:li!!HHG00"ȓ  ;GIF89a    VKG߷xuzw¾md`pgculiyqmvsh^[ұ|spdZV鮩_TQʄ|y\RNŹe[XYOK䦠ǈ}yv}urԤwnkqhesjfi`\aWSxol˩|}zlb_ÿ`VR]SOXMIoebcYU{rotkh[PLka^         !NETSCAPE2.0   !Created with ajaxload.info !	
   ,        #)-$*.6:7
%+/70=66  =?=3@?
 ;E7A>B;>CD	;+F &03	8<݄!'14,<	"PF` !	
   ,        ;WX[] <UY-\$_&JOSHTJ^*\GP2
#7HKQ :6L=FF'MĳNA:b IT@ ?R/D924I	::/E`ӃA&V,ZJCaTT9Ij   !	
   ,        	
i^, CK
jl8^ghQCRk"dN<h-Pcf m],>Jnj2H0T.-435GЄ`eC6:f:=σG5AT770/6@C(CBA;@/܆F	r Z@ !	
   ,        ?(N!lG 9'g[jNJA#HlF=B]O<T&28f_L;9V( HJ,	kWlf:UolǐTr<bJmKG(>N*#F`8"p
A/`9"07 qE	"T=36n Fo) !	
   ,        aoe&? 	+qe4H2D<
@33
%F8<;J @@c e[l>8TBjuaB7KAǐ0Cv^	ur6b?ՅY)3T3+'s
6F0:.ntn830֭ !	
   ,        0@9(+A TA8cJq
>`GT6:"VVA6@>/B4eb=	oRTD3 >hF^M'0F7BLd63Ӑ]jl7ۅ&NG+TTc1SOJvwn\-Yr<A#iΔ@ !	
   ,        7=?;>;"0 :TD	AB8Q"6/3 7;(I@0=:GJ73QfA6D,<3e34.1&2*^Z\<N|Zk-xcVz^8Oyrvj{Ce H`X  !	
   ,        7:FF663FbDD=&:E;A
.TA>3#*N 	DK$+C9\T6Jc-: gY(DZeu,AKXq oPt2Q=FAl!+ OjLM^aG1N\@ÕA  ;GIF89a                                             !  ,      @$R$
E<+Y(	c$X  ːz$H #q0\Y@(bGI<`84n#
	k]oG1Hg%	/0O"DC2^o! ;GIF89a    H DŜw̵৕`șعKԌ֪xtն嶹ڛΖYǉmdѭƾΨӰՔ<{߳ʘh{=Q۝ۗܬ徰Ճr׋s^ؽЬ̙ąޣ3                                                                                                                                                                        ! H ,        @H"B5>> ;+H
H2%


13	"2D6,,4'2
288ֈ27E ((.F# !8"*H	M $xRBoro@

:ѣGoЍ`@`S$8 бa>zX-:ExXㅎoBPb]CpaEȅ)F)A >̹2@8mSjoCGIXik<Mժ	Оl.[/j@w^n7W ;GIF89a    pŶ̜˓լֳ֕ʂzغϤϒ̍                  !  ,       G`&di(JETJ.Ff!nQ)YMA40| HI`@b$0| ;GIF89a  ) GxKUUW~[\cefmoopruvy||~΂˃ٌَ҆͌юٔۙCr                                                                     ! ) ,      @wpH,2,d:sPP%G)j-DH2*bNH8#B~`cmf UD"r%$u	J!(&|BHu~PC (( eD#A ; JFIF  H H   C 		



           C

                                                                                                                      ? 쑖J(   ,@(  Q`?(function(a,b){var c=function(a){return a.innerHTML="<x-element></x-element>",a.childNodes.length===1}(b.createElement("a")),d=function(a,b,c){return b.appendChild(a),(c=(c?c(a):a.currentStyle).display)&&b.removeChild(a)&&c==="block"}(b.createElement("nav"),b.documentElement,a.getComputedStyle),e={elements:"abbr article aside audio bdi canvas data datalist details figcaption figure footer header hgroup mark meter nav output progress section summary time video".split(" "),shivDocument:function(a){a=a||b;if(a.documentShived)return;a.documentShived=!0;var f=a.createElement,g=a.createDocumentFragment,h=a.getElementsByTagName("head")[0],i=function(a){f(a)};c||(e.elements.join(" ").replace(/\w+/g,i),a.createElement=function(a){var b=f(a);return b.canHaveChildren&&e.shivDocument(b.document),b},a.createDocumentFragment=function(){return e.shivDocument(g())});if(!d&&h){var j=f("div");j.innerHTML=["x<style>","article,aside,details,figcaption,figure,footer,header,hgroup,nav,section{display:block}","audio{display:none}","canvas,video{display:inline-block;*display:inline;*zoom:1}","[hidden]{display:none}audio[controls]{display:inline-block;*display:inline;*zoom:1}","mark{background:#FF0;color:#000}","</style>"].join(""),h.insertBefore(j.lastChild,h.firstChild)}return a}};e.shivDocument(b),a.html5=e})(this,document)LiveUpdate={labels:{},output:"o1",toggle:function(){var t=$("toggler").checked;$$("tr").filter(function(e){return e.hasClass("legacy")}).each(function(e){e.toggleClass("hide",!t)})},loading:function(e){e?LiveUpdate.inject("p",'<img src="assets/images/loading.gif" alt="" style="margin-top:3px">'):$(this.output).getLast("p").destroy()},inject:function(e,t,i){var n=new Element(e);n.set("html",t),i&&n.set("class",i),n.inject($(this.output))},process:function(){new Request.JSON({onSuccess:function(e){LiveUpdate.labels=e,LiveUpdate.compare()},onFailure:function(e){LiveUpdate.inject("p",e.responseText,"tl_error")}}).get({do:"labels"})},compare:function(){LiveUpdate.inject("h3",LiveUpdate.labels.step+" 1"),LiveUpdate.inject("p",LiveUpdate.labels.step_1),LiveUpdate.loading(!0),new Request({onComplete:function(){LiveUpdate.loading(!1)},onSuccess:function(e){210==this.status?(LiveUpdate.inject("p",e,"tl_confirm"),LiveUpdate.templates()):(LiveUpdate.inject("p",e,"tl_info"),LiveUpdate.backup())},onFailure:function(e){LiveUpdate.inject("p",e.responseText,"tl_error")}}).get({do:"compare"})},backup:function(){LiveUpdate.inject("h3",LiveUpdate.labels.step+" 2"),LiveUpdate.inject("p",LiveUpdate.labels.step_2),LiveUpdate.loading(!0),new Request({onComplete:function(){LiveUpdate.loading(!1)},onSuccess:function(e){209==this.status?LiveUpdate.inject("p",e,"tl_info"):LiveUpdate.inject("p",e,"tl_confirm"),LiveUpdate.download()},onFailure:function(e){LiveUpdate.inject("p",e.responseText,"tl_error")}}).get({do:"backup"})},download:function(){LiveUpdate.inject("h3",LiveUpdate.labels.step+" 3"),LiveUpdate.inject("p",LiveUpdate.labels.step_3),LiveUpdate.loading(!0),new Request({onComplete:function(){LiveUpdate.loading(!1)},onSuccess:function(e){LiveUpdate.inject("p",e,"tl_confirm"),LiveUpdate.extract()},onFailure:function(e){LiveUpdate.inject("p",e.responseText,"tl_error")}}).get({do:"download"})},extract:function(){LiveUpdate.inject("h3",LiveUpdate.labels.step+" 4"),LiveUpdate.inject("p",LiveUpdate.labels.step_4),LiveUpdate.loading(!0),new Request({onComplete:function(){LiveUpdate.loading(!1)},onSuccess:function(e){LiveUpdate.inject("p",e,"tl_confirm"),LiveUpdate.restore()},onFailure:function(e){LiveUpdate.inject("p",e.responseText,"tl_error")}}).get({do:"extract"})},restore:function(){LiveUpdate.inject("h3",LiveUpdate.labels.step+" 5"),LiveUpdate.inject("p",LiveUpdate.labels.step_5),LiveUpdate.loading(!0),new Request({onComplete:function(){LiveUpdate.loading(!1)},onSuccess:function(e){209==this.status?LiveUpdate.inject("p",e,"tl_info"):LiveUpdate.inject("p",e,"tl_confirm"),LiveUpdate.recompare()},onFailure:function(e){LiveUpdate.inject("p",e.responseText,"tl_error")}}).get({do:"restore"})},recompare:function(){LiveUpdate.inject("h3",LiveUpdate.labels.step+" 6"),LiveUpdate.inject("p",LiveUpdate.labels.step_6),LiveUpdate.loading(!0),new Request({onComplete:function(){LiveUpdate.loading(!1)},onSuccess:function(e){LiveUpdate.inject("p",e,"tl_confirm"),LiveUpdate.runonce()},onFailure:function(e){LiveUpdate.inject("p",e.responseText,"tl_error"),LiveUpdate.templates()}}).get({do:"recompare"})},runonce:function(){LiveUpdate.inject("h3",LiveUpdate.labels.step+" 7"),LiveUpdate.inject("p",LiveUpdate.labels.step_6a),LiveUpdate.loading(!0),setTimeout(function(){new Request({onComplete:function(){LiveUpdate.loading(!1)},onSuccess:function(e){209==this.status?(LiveUpdate.inject("div",e,"update_hint"),$("go_to_login").style.visibility="hidden"):LiveUpdate.inject("p",e,"tl_confirm")},onFailure:function(e){LiveUpdate.inject("p",e.responseText,"tl_error")}}).get({do:"runonce"})},2e3)}};(function(){this.MooTools={version:"1.4.5",build:"ab8ea8824dc3b24b6666867a2c4ed58ebb762cf0"};var o=this.typeOf=function(i){if(i==null){return"null";}if(i.$family!=null){return i.$family();}if(i.nodeName){if(i.nodeType==1){return"element";}if(i.nodeType==3){return(/\S/).test(i.nodeValue)?"textnode":"whitespace";}}else{if(typeof i.length=="number"){if(i.callee){return"arguments";}if("item" in i){return"collection";}}}return typeof i;};var j=this.instanceOf=function(t,i){if(t==null){return false;}var s=t.$constructor||t.constructor;while(s){if(s===i){return true;}s=s.parent;}if(!t.hasOwnProperty){return false;}return t instanceof i;};var f=this.Function;var p=true;for(var k in {toString:1}){p=null;}if(p){p=["hasOwnProperty","valueOf","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","constructor"];}f.prototype.overloadSetter=function(s){var i=this;return function(u,t){if(u==null){return this;}if(s||typeof u!="string"){for(var v in u){i.call(this,v,u[v]);}if(p){for(var w=p.length;w--;){v=p[w];if(u.hasOwnProperty(v)){i.call(this,v,u[v]);}}}}else{i.call(this,u,t);}return this;};};f.prototype.overloadGetter=function(s){var i=this;return function(u){var v,t;if(typeof u!="string"){v=u;}else{if(arguments.length>1){v=arguments;}else{if(s){v=[u];}}}if(v){t={};for(var w=0;w<v.length;w++){t[v[w]]=i.call(this,v[w]);}}else{t=i.call(this,u);}return t;};};f.prototype.extend=function(i,s){this[i]=s;}.overloadSetter();f.prototype.implement=function(i,s){this.prototype[i]=s;}.overloadSetter();var n=Array.prototype.slice;f.from=function(i){return(o(i)=="function")?i:function(){return i;};};Array.from=function(i){if(i==null){return[];}return(a.isEnumerable(i)&&typeof i!="string")?(o(i)=="array")?i:n.call(i):[i];};Number.from=function(s){var i=parseFloat(s);return isFinite(i)?i:null;};String.from=function(i){return i+"";};f.implement({hide:function(){this.$hidden=true;return this;},protect:function(){this.$protected=true;return this;}});var a=this.Type=function(u,t){if(u){var s=u.toLowerCase();var i=function(v){return(o(v)==s);};a["is"+u]=i;if(t!=null){t.prototype.$family=(function(){return s;}).hide();}}if(t==null){return null;}t.extend(this);t.$constructor=a;t.prototype.$constructor=t;return t;};var e=Object.prototype.toString;a.isEnumerable=function(i){return(i!=null&&typeof i.length=="number"&&e.call(i)!="[object Function]");};var q={};var r=function(i){var s=o(i.prototype);return q[s]||(q[s]=[]);};var b=function(t,x){if(x&&x.$hidden){return;}var s=r(this);for(var u=0;u<s.length;u++){var w=s[u];if(o(w)=="type"){b.call(w,t,x);}else{w.call(this,t,x);}}var v=this.prototype[t];if(v==null||!v.$protected){this.prototype[t]=x;}if(this[t]==null&&o(x)=="function"){m.call(this,t,function(i){return x.apply(i,n.call(arguments,1));});}};var m=function(i,t){if(t&&t.$hidden){return;}var s=this[i];if(s==null||!s.$protected){this[i]=t;}};a.implement({implement:b.overloadSetter(),extend:m.overloadSetter(),alias:function(i,s){b.call(this,i,this.prototype[s]);}.overloadSetter(),mirror:function(i){r(this).push(i);return this;}});new a("Type",a);var d=function(s,x,v){var u=(x!=Object),B=x.prototype;if(u){x=new a(s,x);}for(var y=0,w=v.length;y<w;y++){var C=v[y],A=x[C],z=B[C];if(A){A.protect();}if(u&&z){x.implement(C,z.protect());}}if(u){var t=B.propertyIsEnumerable(v[0]);x.forEachMethod=function(G){if(!t){for(var F=0,D=v.length;F<D;F++){G.call(B,B[v[F]],v[F]);}}for(var E in B){G.call(B,B[E],E);}};}return d;};d("String",String,["charAt","charCodeAt","concat","indexOf","lastIndexOf","match","quote","replace","search","slice","split","substr","substring","trim","toLowerCase","toUpperCase"])("Array",Array,["pop","push","reverse","shift","sort","splice","unshift","concat","join","slice","indexOf","lastIndexOf","filter","forEach","every","map","some","reduce","reduceRight"])("Number",Number,["toExponential","toFixed","toLocaleString","toPrecision"])("Function",f,["apply","call","bind"])("RegExp",RegExp,["exec","test"])("Object",Object,["create","defineProperty","defineProperties","keys","getPrototypeOf","getOwnPropertyDescriptor","getOwnPropertyNames","preventExtensions","isExtensible","seal","isSealed","freeze","isFrozen"])("Date",Date,["now"]);Object.extend=m.overloadSetter();Date.extend("now",function(){return +(new Date);});new a("Boolean",Boolean);Number.prototype.$family=function(){return isFinite(this)?"number":"null";}.hide();Number.extend("random",function(s,i){return Math.floor(Math.random()*(i-s+1)+s);});var g=Object.prototype.hasOwnProperty;Object.extend("forEach",function(i,t,u){for(var s in i){if(g.call(i,s)){t.call(u,i[s],s,i);}}});Object.each=Object.forEach;Array.implement({forEach:function(u,v){for(var t=0,s=this.length;t<s;t++){if(t in this){u.call(v,this[t],t,this);}}},each:function(i,s){Array.forEach(this,i,s);return this;}});var l=function(i){switch(o(i)){case"array":return i.clone();case"object":return Object.clone(i);default:return i;}};Array.implement("clone",function(){var s=this.length,t=new Array(s);while(s--){t[s]=l(this[s]);}return t;});var h=function(s,i,t){switch(o(t)){case"object":if(o(s[i])=="object"){Object.merge(s[i],t);}else{s[i]=Object.clone(t);}break;case"array":s[i]=t.clone();break;default:s[i]=t;}return s;};Object.extend({merge:function(z,u,t){if(o(u)=="string"){return h(z,u,t);}for(var y=1,s=arguments.length;y<s;y++){var w=arguments[y];for(var x in w){h(z,x,w[x]);}}return z;},clone:function(i){var t={};for(var s in i){t[s]=l(i[s]);}return t;},append:function(w){for(var v=1,t=arguments.length;v<t;v++){var s=arguments[v]||{};for(var u in s){w[u]=s[u];}}return w;}});["Object","WhiteSpace","TextNode","Collection","Arguments"].each(function(i){new a(i);});var c=Date.now();String.extend("uniqueID",function(){return(c++).toString(36);});})();(function(){var a=Object.prototype.hasOwnProperty;Object.extend({subset:function(d,g){var f={};for(var e=0,b=g.length;e<b;e++){var c=g[e];if(c in d){f[c]=d[c];}}return f;},map:function(b,e,f){var d={};for(var c in b){if(a.call(b,c)){d[c]=e.call(f,b[c],c,b);}}return d;},filter:function(b,e,g){var d={};for(var c in b){var f=b[c];if(a.call(b,c)&&e.call(g,f,c,b)){d[c]=f;}}return d;},every:function(b,d,e){for(var c in b){if(a.call(b,c)&&!d.call(e,b[c],c)){return false;}}return true;},some:function(b,d,e){for(var c in b){if(a.call(b,c)&&d.call(e,b[c],c)){return true;}}return false;},keys:function(b){var d=[];for(var c in b){if(a.call(b,c)){d.push(c);}}return d;},values:function(c){var b=[];for(var d in c){if(a.call(c,d)){b.push(c[d]);}}return b;},getLength:function(b){return Object.keys(b).length;},keyOf:function(b,d){for(var c in b){if(a.call(b,c)&&b[c]===d){return c;}}return null;},contains:function(b,c){return Object.keyOf(b,c)!=null;},toQueryString:function(b,c){var d=[];Object.each(b,function(h,g){if(c){g=c+"["+g+"]";}var f;switch(typeOf(h)){case"object":f=Object.toQueryString(h,g);break;case"array":var e={};h.each(function(k,j){e[j]=k;});f=Object.toQueryString(e,g);break;default:f=g+"="+encodeURIComponent(h);}if(h!=null){d.push(f);}});return d.join("&");}});})();Array.implement({every:function(c,d){for(var b=0,a=this.length>>>0;b<a;b++){if((b in this)&&!c.call(d,this[b],b,this)){return false;}}return true;},filter:function(d,f){var c=[];for(var e,b=0,a=this.length>>>0;b<a;b++){if(b in this){e=this[b];if(d.call(f,e,b,this)){c.push(e);}}}return c;},indexOf:function(c,d){var b=this.length>>>0;for(var a=(d<0)?Math.max(0,b+d):d||0;a<b;a++){if(this[a]===c){return a;}}return -1;},map:function(c,e){var d=this.length>>>0,b=Array(d);for(var a=0;a<d;a++){if(a in this){b[a]=c.call(e,this[a],a,this);}}return b;},some:function(c,d){for(var b=0,a=this.length>>>0;b<a;b++){if((b in this)&&c.call(d,this[b],b,this)){return true;}}return false;},clean:function(){return this.filter(function(a){return a!=null;});},invoke:function(a){var b=Array.slice(arguments,1);return this.map(function(c){return c[a].apply(c,b);});},associate:function(c){var d={},b=Math.min(this.length,c.length);for(var a=0;a<b;a++){d[c[a]]=this[a];}return d;},link:function(c){var a={};for(var e=0,b=this.length;e<b;e++){for(var d in c){if(c[d](this[e])){a[d]=this[e];delete c[d];break;}}}return a;},contains:function(a,b){return this.indexOf(a,b)!=-1;},append:function(a){this.push.apply(this,a);return this;},getLast:function(){return(this.length)?this[this.length-1]:null;},getRandom:function(){return(this.length)?this[Number.random(0,this.length-1)]:null;},include:function(a){if(!this.contains(a)){this.push(a);}return this;},combine:function(c){for(var b=0,a=c.length;b<a;b++){this.include(c[b]);}return this;},erase:function(b){for(var a=this.length;a--;){if(this[a]===b){this.splice(a,1);}}return this;},empty:function(){this.length=0;return this;},flatten:function(){var d=[];for(var b=0,a=this.length;b<a;b++){var c=typeOf(this[b]);if(c=="null"){continue;}d=d.concat((c=="array"||c=="collection"||c=="arguments"||instanceOf(this[b],Array))?Array.flatten(this[b]):this[b]);}return d;},pick:function(){for(var b=0,a=this.length;b<a;b++){if(this[b]!=null){return this[b];}}return null;},hexToRgb:function(b){if(this.length!=3){return null;}var a=this.map(function(c){if(c.length==1){c+=c;}return c.toInt(16);});return(b)?a:"rgb("+a+")";},rgbToHex:function(d){if(this.length<3){return null;}if(this.length==4&&this[3]==0&&!d){return"transparent";}var b=[];for(var a=0;a<3;a++){var c=(this[a]-0).toString(16);b.push((c.length==1)?"0"+c:c);}return(d)?b:"#"+b.join("");}});Function.extend({attempt:function(){for(var b=0,a=arguments.length;b<a;b++){try{return arguments[b]();}catch(c){}}return null;}});Function.implement({attempt:function(a,c){try{return this.apply(c,Array.from(a));}catch(b){}return null;},bind:function(e){var a=this,b=arguments.length>1?Array.slice(arguments,1):null,d=function(){};var c=function(){var g=e,h=arguments.length;if(this instanceof c){d.prototype=a.prototype;g=new d;}var f=(!b&&!h)?a.call(g):a.apply(g,b&&h?b.concat(Array.slice(arguments)):b||arguments);return g==e?f:g;};return c;},pass:function(b,c){var a=this;if(b!=null){b=Array.from(b);}return function(){return a.apply(c,b||arguments);};},delay:function(b,c,a){return setTimeout(this.pass((a==null?[]:a),c),b);},periodical:function(c,b,a){return setInterval(this.pass((a==null?[]:a),b),c);}});Number.implement({limit:function(b,a){return Math.min(a,Math.max(b,this));},round:function(a){a=Math.pow(10,a||0).toFixed(a<0?-a:0);return Math.round(this*a)/a;},times:function(b,c){for(var a=0;a<this;a++){b.call(c,a,this);}},toFloat:function(){return parseFloat(this);},toInt:function(a){return parseInt(this,a||10);}});Number.alias("each","times");(function(b){var a={};b.each(function(c){if(!Number[c]){a[c]=function(){return Math[c].apply(null,[this].concat(Array.from(arguments)));};}});Number.implement(a);})(["abs","acos","asin","atan","atan2","ceil","cos","exp","floor","log","max","min","pow","sin","sqrt","tan"]);String.implement({test:function(a,b){return((typeOf(a)=="regexp")?a:new RegExp(""+a,b)).test(this);},contains:function(a,b){return(b)?(b+this+b).indexOf(b+a+b)>-1:String(this).indexOf(a)>-1;},trim:function(){return String(this).replace(/^\s+|\s+$/g,"");},clean:function(){return String(this).replace(/\s+/g," ").trim();},camelCase:function(){return String(this).replace(/-\D/g,function(a){return a.charAt(1).toUpperCase();});},hyphenate:function(){return String(this).replace(/[A-Z]/g,function(a){return("-"+a.charAt(0).toLowerCase());});},capitalize:function(){return String(this).replace(/\b[a-z]/g,function(a){return a.toUpperCase();});},escapeRegExp:function(){return String(this).replace(/([-.*+?^${}()|[\]\/\\])/g,"\\$1");},toInt:function(a){return parseInt(this,a||10);},toFloat:function(){return parseFloat(this);},hexToRgb:function(b){var a=String(this).match(/^#?(\w{1,2})(\w{1,2})(\w{1,2})$/);return(a)?a.slice(1).hexToRgb(b):null;},rgbToHex:function(b){var a=String(this).match(/\d{1,3}/g);return(a)?a.rgbToHex(b):null;},substitute:function(a,b){return String(this).replace(b||(/\\?\{([^{}]+)\}/g),function(d,c){if(d.charAt(0)=="\\"){return d.slice(1);}return(a[c]!=null)?a[c]:"";});}});(function(){var j=this.document;var g=j.window=this;var a=navigator.userAgent.toLowerCase(),b=navigator.platform.toLowerCase(),h=a.match(/(opera|ie|firefox|chrome|version)[\s\/:]([\w\d\.]+)?.*?(safari|version[\s\/:]([\w\d\.]+)|$)/)||[null,"unknown",0],d=h[1]=="ie"&&j.documentMode;var n=this.Browser={extend:Function.prototype.extend,name:(h[1]=="version")?h[3]:h[1],version:d||parseFloat((h[1]=="opera"&&h[4])?h[4]:h[2]),Platform:{name:a.match(/ip(?:ad|od|hone)/)?"ios":(a.match(/(?:webos|android)/)||b.match(/mac|win|linux/)||["other"])[0]},Features:{xpath:!!(j.evaluate),air:!!(g.runtime),query:!!(j.querySelector),json:!!(g.JSON)},Plugins:{}};n[n.name]=true;n[n.name+parseInt(n.version,10)]=true;n.Platform[n.Platform.name]=true;n.Request=(function(){var p=function(){return new XMLHttpRequest();};var o=function(){return new ActiveXObject("MSXML2.XMLHTTP");};var e=function(){return new ActiveXObject("Microsoft.XMLHTTP");};return Function.attempt(function(){p();return p;},function(){o();return o;},function(){e();return e;});})();n.Features.xhr=!!(n.Request);var i=(Function.attempt(function(){return navigator.plugins["Shockwave Flash"].description;},function(){return new ActiveXObject("ShockwaveFlash.ShockwaveFlash").GetVariable("$version");})||"0 r0").match(/\d+/g);n.Plugins.Flash={version:Number(i[0]||"0."+i[1])||0,build:Number(i[2])||0};n.exec=function(o){if(!o){return o;}if(g.execScript){g.execScript(o);}else{var e=j.createElement("script");e.setAttribute("type","text/javascript");e.text=o;j.head.appendChild(e);j.head.removeChild(e);}return o;};String.implement("stripScripts",function(o){var e="";var p=this.replace(/<script[^>]*>([\s\S]*?)<\/script>/gi,function(q,r){e+=r+"\n";return"";});if(o===true){n.exec(e);}else{if(typeOf(o)=="function"){o(e,p);}}return p;});n.extend({Document:this.Document,Window:this.Window,Element:this.Element,Event:this.Event});this.Window=this.$constructor=new Type("Window",function(){});this.$family=Function.from("window").hide();Window.mirror(function(e,o){g[e]=o;});this.Document=j.$constructor=new Type("Document",function(){});j.$family=Function.from("document").hide();Document.mirror(function(e,o){j[e]=o;});j.html=j.documentElement;if(!j.head){j.head=j.getElementsByTagName("head")[0];}if(j.execCommand){try{j.execCommand("BackgroundImageCache",false,true);}catch(f){}}if(this.attachEvent&&!this.addEventListener){var c=function(){this.detachEvent("onunload",c);j.head=j.html=j.window=null;};this.attachEvent("onunload",c);}var l=Array.from;try{l(j.html.childNodes);}catch(f){Array.from=function(o){if(typeof o!="string"&&Type.isEnumerable(o)&&typeOf(o)!="array"){var e=o.length,p=new Array(e);while(e--){p[e]=o[e];}return p;}return l(o);};var k=Array.prototype,m=k.slice;["pop","push","reverse","shift","sort","splice","unshift","concat","join","slice"].each(function(e){var o=k[e];Array[e]=function(p){return o.apply(Array.from(p),m.call(arguments,1));};});}})();(function(){var k,n,l,g,a={},c={},m=/\\/g;var e=function(q,p){if(q==null){return null;}if(q.Slick===true){return q;}q=(""+q).replace(/^\s+|\s+$/g,"");g=!!p;var o=(g)?c:a;if(o[q]){return o[q];}k={Slick:true,expressions:[],raw:q,reverse:function(){return e(this.raw,true);}};n=-1;while(q!=(q=q.replace(j,b))){}k.length=k.expressions.length;return o[k.raw]=(g)?h(k):k;};var i=function(o){if(o==="!"){return" ";}else{if(o===" "){return"!";}else{if((/^!/).test(o)){return o.replace(/^!/,"");}else{return"!"+o;}}}};var h=function(u){var r=u.expressions;for(var p=0;p<r.length;p++){var t=r[p];var q={parts:[],tag:"*",combinator:i(t[0].combinator)};for(var o=0;o<t.length;o++){var s=t[o];if(!s.reverseCombinator){s.reverseCombinator=" ";}s.combinator=s.reverseCombinator;delete s.reverseCombinator;}t.reverse().push(q);}return u;};var f=function(o){return o.replace(/[-[\]{}()*+?.\\^$|,#\s]/g,function(p){return"\\"+p;});};var j=new RegExp("^(?:\\s*(,)\\s*|\\s*(<combinator>+)\\s*|(\\s+)|(<unicode>+|\\*)|\\#(<unicode>+)|\\.(<unicode>+)|\\[\\s*(<unicode1>+)(?:\\s*([*^$!~|]?=)(?:\\s*(?:([\"']?)(.*?)\\9)))?\\s*\\](?!\\])|(:+)(<unicode>+)(?:\\((?:(?:([\"'])([^\\13]*)\\13)|((?:\\([^)]+\\)|[^()]*)+))\\))?)".replace(/<combinator>/,"["+f(">+~`!@$%^&={}\\;</")+"]").replace(/<unicode>/g,"(?:[\\w\\u00a1-\\uFFFF-]|\\\\[^\\s0-9a-f])").replace(/<unicode1>/g,"(?:[:\\w\\u00a1-\\uFFFF-]|\\\\[^\\s0-9a-f])"));function b(x,s,D,z,r,C,q,B,A,y,u,F,G,v,p,w){if(s||n===-1){k.expressions[++n]=[];l=-1;if(s){return"";}}if(D||z||l===-1){D=D||" ";var t=k.expressions[n];if(g&&t[l]){t[l].reverseCombinator=i(D);}t[++l]={combinator:D,tag:"*"};}var o=k.expressions[n][l];if(r){o.tag=r.replace(m,"");}else{if(C){o.id=C.replace(m,"");}else{if(q){q=q.replace(m,"");if(!o.classList){o.classList=[];}if(!o.classes){o.classes=[];}o.classList.push(q);o.classes.push({value:q,regexp:new RegExp("(^|\\s)"+f(q)+"(\\s|$)")});}else{if(G){w=w||p;w=w?w.replace(m,""):null;if(!o.pseudos){o.pseudos=[];}o.pseudos.push({key:G.replace(m,""),value:w,type:F.length==1?"class":"element"});}else{if(B){B=B.replace(m,"");u=(u||"").replace(m,"");var E,H;switch(A){case"^=":H=new RegExp("^"+f(u));break;case"$=":H=new RegExp(f(u)+"$");break;case"~=":H=new RegExp("(^|\\s)"+f(u)+"(\\s|$)");break;case"|=":H=new RegExp("^"+f(u)+"(-|$)");break;case"=":E=function(I){return u==I;};break;case"*=":E=function(I){return I&&I.indexOf(u)>-1;};break;case"!=":E=function(I){return u!=I;};break;default:E=function(I){return !!I;};}if(u==""&&(/^[*$^]=$/).test(A)){E=function(){return false;};}if(!E){E=function(I){return I&&H.test(I);};}if(!o.attributes){o.attributes=[];}o.attributes.push({key:B,operator:A,value:u,test:E});}}}}}return"";}var d=(this.Slick||{});d.parse=function(o){return e(o);};d.escapeRegExp=f;if(!this.Slick){this.Slick=d;}}).apply((typeof exports!="undefined")?exports:this);(function(){var k={},m={},d=Object.prototype.toString;k.isNativeCode=function(c){return(/\{\s*\[native code\]\s*\}/).test(""+c);};k.isXML=function(c){return(!!c.xmlVersion)||(!!c.xml)||(d.call(c)=="[object XMLDocument]")||(c.nodeType==9&&c.documentElement.nodeName!="HTML");};k.setDocument=function(w){var p=w.nodeType;if(p==9){}else{if(p){w=w.ownerDocument;}else{if(w.navigator){w=w.document;}else{return;}}}if(this.document===w){return;}this.document=w;var A=w.documentElement,o=this.getUIDXML(A),s=m[o],r;if(s){for(r in s){this[r]=s[r];}return;}s=m[o]={};s.root=A;s.isXMLDocument=this.isXML(w);s.brokenStarGEBTN=s.starSelectsClosedQSA=s.idGetsName=s.brokenMixedCaseQSA=s.brokenGEBCN=s.brokenCheckedQSA=s.brokenEmptyAttributeQSA=s.isHTMLDocument=s.nativeMatchesSelector=false;var q,u,y,z,t;var x,v="slick_uniqueid";var c=w.createElement("div");var n=w.body||w.getElementsByTagName("body")[0]||A;n.appendChild(c);try{c.innerHTML='<a id="'+v+'"></a>';s.isHTMLDocument=!!w.getElementById(v);}catch(C){}if(s.isHTMLDocument){c.style.display="none";c.appendChild(w.createComment(""));u=(c.getElementsByTagName("*").length>1);try{c.innerHTML="foo</foo>";x=c.getElementsByTagName("*");q=(x&&!!x.length&&x[0].nodeName.charAt(0)=="/");}catch(C){}s.brokenStarGEBTN=u||q;try{c.innerHTML='<a name="'+v+'"></a><b id="'+v+'"></b>';s.idGetsName=w.getElementById(v)===c.firstChild;}catch(C){}if(c.getElementsByClassName){try{c.innerHTML='<a class="f"></a><a class="b"></a>';c.getElementsByClassName("b").length;c.firstChild.className="b";z=(c.getElementsByClassName("b").length!=2);}catch(C){}try{c.innerHTML='<a class="a"></a><a class="f b a"></a>';y=(c.getElementsByClassName("a").length!=2);}catch(C){}s.brokenGEBCN=z||y;}if(c.querySelectorAll){try{c.innerHTML="foo</foo>";x=c.querySelectorAll("*");s.starSelectsClosedQSA=(x&&!!x.length&&x[0].nodeName.charAt(0)=="/");}catch(C){}try{c.innerHTML='<a class="MiX"></a>';s.brokenMixedCaseQSA=!c.querySelectorAll(".MiX").length;}catch(C){}try{c.innerHTML='<select><option selected="selected">a</option></select>';s.brokenCheckedQSA=(c.querySelectorAll(":checked").length==0);}catch(C){}try{c.innerHTML='<a class=""></a>';s.brokenEmptyAttributeQSA=(c.querySelectorAll('[class*=""]').length!=0);}catch(C){}}try{c.innerHTML='<form action="s"><input id="action"/></form>';t=(c.firstChild.getAttribute("action")!="s");}catch(C){}s.nativeMatchesSelector=A.matchesSelector||A.mozMatchesSelector||A.webkitMatchesSelector;if(s.nativeMatchesSelector){try{s.nativeMatchesSelector.call(A,":slick");s.nativeMatchesSelector=null;}catch(C){}}}try{A.slick_expando=1;delete A.slick_expando;s.getUID=this.getUIDHTML;}catch(C){s.getUID=this.getUIDXML;}n.removeChild(c);c=x=n=null;s.getAttribute=(s.isHTMLDocument&&t)?function(G,E){var H=this.attributeGetters[E];if(H){return H.call(G);}var F=G.getAttributeNode(E);return(F)?F.nodeValue:null;}:function(F,E){var G=this.attributeGetters[E];return(G)?G.call(F):F.getAttribute(E);};s.hasAttribute=(A&&this.isNativeCode(A.hasAttribute))?function(F,E){return F.hasAttribute(E);}:function(F,E){F=F.getAttributeNode(E);return !!(F&&(F.specified||F.nodeValue));};var D=A&&this.isNativeCode(A.contains),B=w&&this.isNativeCode(w.contains);s.contains=(D&&B)?function(E,F){return E.contains(F);}:(D&&!B)?function(E,F){return E===F||((E===w)?w.documentElement:E).contains(F);}:(A&&A.compareDocumentPosition)?function(E,F){return E===F||!!(E.compareDocumentPosition(F)&16);}:function(E,F){if(F){do{if(F===E){return true;}}while((F=F.parentNode));}return false;};s.documentSorter=(A.compareDocumentPosition)?function(F,E){if(!F.compareDocumentPosition||!E.compareDocumentPosition){return 0;}return F.compareDocumentPosition(E)&4?-1:F===E?0:1;}:("sourceIndex" in A)?function(F,E){if(!F.sourceIndex||!E.sourceIndex){return 0;}return F.sourceIndex-E.sourceIndex;}:(w.createRange)?function(H,F){if(!H.ownerDocument||!F.ownerDocument){return 0;}var G=H.ownerDocument.createRange(),E=F.ownerDocument.createRange();G.setStart(H,0);G.setEnd(H,0);E.setStart(F,0);E.setEnd(F,0);return G.compareBoundaryPoints(Range.START_TO_END,E);}:null;A=null;for(r in s){this[r]=s[r];}};var f=/^([#.]?)((?:[\w-]+|\*))$/,h=/\[.+[*$^]=(?:""|'')?\]/,g={};k.search=function(U,z,H,s){var p=this.found=(s)?null:(H||[]);if(!U){return p;}else{if(U.navigator){U=U.document;}else{if(!U.nodeType){return p;}}}var F,O,V=this.uniques={},I=!!(H&&H.length),y=(U.nodeType==9);if(this.document!==(y?U:U.ownerDocument)){this.setDocument(U);}if(I){for(O=p.length;O--;){V[this.getUID(p[O])]=true;}}if(typeof z=="string"){var r=z.match(f);simpleSelectors:if(r){var u=r[1],v=r[2],A,E;if(!u){if(v=="*"&&this.brokenStarGEBTN){break simpleSelectors;}E=U.getElementsByTagName(v);if(s){return E[0]||null;}for(O=0;A=E[O++];){if(!(I&&V[this.getUID(A)])){p.push(A);}}}else{if(u=="#"){if(!this.isHTMLDocument||!y){break simpleSelectors;}A=U.getElementById(v);if(!A){return p;}if(this.idGetsName&&A.getAttributeNode("id").nodeValue!=v){break simpleSelectors;}if(s){return A||null;}if(!(I&&V[this.getUID(A)])){p.push(A);}}else{if(u=="."){if(!this.isHTMLDocument||((!U.getElementsByClassName||this.brokenGEBCN)&&U.querySelectorAll)){break simpleSelectors;}if(U.getElementsByClassName&&!this.brokenGEBCN){E=U.getElementsByClassName(v);if(s){return E[0]||null;}for(O=0;A=E[O++];){if(!(I&&V[this.getUID(A)])){p.push(A);}}}else{var T=new RegExp("(^|\\s)"+e.escapeRegExp(v)+"(\\s|$)");E=U.getElementsByTagName("*");for(O=0;A=E[O++];){className=A.className;if(!(className&&T.test(className))){continue;}if(s){return A;}if(!(I&&V[this.getUID(A)])){p.push(A);}}}}}}if(I){this.sort(p);}return(s)?null:p;}querySelector:if(U.querySelectorAll){if(!this.isHTMLDocument||g[z]||this.brokenMixedCaseQSA||(this.brokenCheckedQSA&&z.indexOf(":checked")>-1)||(this.brokenEmptyAttributeQSA&&h.test(z))||(!y&&z.indexOf(",")>-1)||e.disableQSA){break querySelector;}var S=z,x=U;if(!y){var C=x.getAttribute("id"),t="slickid__";x.setAttribute("id",t);S="#"+t+" "+S;U=x.parentNode;}try{if(s){return U.querySelector(S)||null;}else{E=U.querySelectorAll(S);}}catch(Q){g[z]=1;break querySelector;}finally{if(!y){if(C){x.setAttribute("id",C);}else{x.removeAttribute("id");}U=x;}}if(this.starSelectsClosedQSA){for(O=0;A=E[O++];){if(A.nodeName>"@"&&!(I&&V[this.getUID(A)])){p.push(A);}}}else{for(O=0;A=E[O++];){if(!(I&&V[this.getUID(A)])){p.push(A);}}}if(I){this.sort(p);}return p;}F=this.Slick.parse(z);if(!F.length){return p;}}else{if(z==null){return p;}else{if(z.Slick){F=z;}else{if(this.contains(U.documentElement||U,z)){(p)?p.push(z):p=z;return p;}else{return p;}}}}this.posNTH={};this.posNTHLast={};this.posNTHType={};this.posNTHTypeLast={};this.push=(!I&&(s||(F.length==1&&F.expressions[0].length==1)))?this.pushArray:this.pushUID;if(p==null){p=[];}var M,L,K;var B,J,D,c,q,G,W;var N,P,o,w,R=F.expressions;search:for(O=0;(P=R[O]);O++){for(M=0;(o=P[M]);M++){B="combinator:"+o.combinator;if(!this[B]){continue search;}J=(this.isXMLDocument)?o.tag:o.tag.toUpperCase();D=o.id;c=o.classList;q=o.classes;G=o.attributes;W=o.pseudos;w=(M===(P.length-1));this.bitUniques={};if(w){this.uniques=V;this.found=p;}else{this.uniques={};this.found=[];}if(M===0){this[B](U,J,D,q,G,W,c);if(s&&w&&p.length){break search;}}else{if(s&&w){for(L=0,K=N.length;L<K;L++){this[B](N[L],J,D,q,G,W,c);if(p.length){break search;}}}else{for(L=0,K=N.length;L<K;L++){this[B](N[L],J,D,q,G,W,c);}}}N=this.found;}}if(I||(F.expressions.length>1)){this.sort(p);}return(s)?(p[0]||null):p;};k.uidx=1;k.uidk="slick-uniqueid";k.getUIDXML=function(n){var c=n.getAttribute(this.uidk);if(!c){c=this.uidx++;n.setAttribute(this.uidk,c);}return c;};k.getUIDHTML=function(c){return c.uniqueNumber||(c.uniqueNumber=this.uidx++);};k.sort=function(c){if(!this.documentSorter){return c;}c.sort(this.documentSorter);return c;};k.cacheNTH={};k.matchNTH=/^([+-]?\d*)?([a-z]+)?([+-]\d+)?$/;k.parseNTHArgument=function(q){var o=q.match(this.matchNTH);if(!o){return false;}var p=o[2]||false;var n=o[1]||1;if(n=="-"){n=-1;}var c=+o[3]||0;o=(p=="n")?{a:n,b:c}:(p=="odd")?{a:2,b:1}:(p=="even")?{a:2,b:0}:{a:0,b:n};return(this.cacheNTH[q]=o);};k.createNTHPseudo=function(p,n,c,o){return function(s,q){var u=this.getUID(s);if(!this[c][u]){var A=s.parentNode;if(!A){return false;}var r=A[p],t=1;if(o){var z=s.nodeName;do{if(r.nodeName!=z){continue;}this[c][this.getUID(r)]=t++;}while((r=r[n]));}else{do{if(r.nodeType!=1){continue;}this[c][this.getUID(r)]=t++;}while((r=r[n]));}}q=q||"n";var v=this.cacheNTH[q]||this.parseNTHArgument(q);if(!v){return false;}var y=v.a,x=v.b,w=this[c][u];if(y==0){return x==w;}if(y>0){if(w<x){return false;}}else{if(x<w){return false;}}return((w-x)%y)==0;};};k.pushArray=function(p,c,r,o,n,q){if(this.matchSelector(p,c,r,o,n,q)){this.found.push(p);}};k.pushUID=function(q,c,s,p,n,r){var o=this.getUID(q);if(!this.uniques[o]&&this.matchSelector(q,c,s,p,n,r)){this.uniques[o]=true;this.found.push(q);}};k.matchNode=function(n,o){if(this.isHTMLDocument&&this.nativeMatchesSelector){try{return this.nativeMatchesSelector.call(n,o.replace(/\[([^=]+)=\s*([^'"\]]+?)\s*\]/g,'[$1="$2"]'));}catch(u){}}var t=this.Slick.parse(o);if(!t){return true;}var r=t.expressions,s=0,q;for(q=0;(currentExpression=r[q]);q++){if(currentExpression.length==1){var p=currentExpression[0];if(this.matchSelector(n,(this.isXMLDocument)?p.tag:p.tag.toUpperCase(),p.id,p.classes,p.attributes,p.pseudos)){return true;}s++;}}if(s==t.length){return false;}var c=this.search(this.document,t),v;for(q=0;v=c[q++];){if(v===n){return true;}}return false;};k.matchPseudo=function(q,c,p){var n="pseudo:"+c;if(this[n]){return this[n](q,p);}var o=this.getAttribute(q,c);return(p)?p==o:!!o;};k.matchSelector=function(o,v,c,p,q,s){if(v){var t=(this.isXMLDocument)?o.nodeName:o.nodeName.toUpperCase();if(v=="*"){if(t<"@"){return false;}}else{if(t!=v){return false;}}}if(c&&o.getAttribute("id")!=c){return false;}var r,n,u;if(p){for(r=p.length;r--;){u=this.getAttribute(o,"class");if(!(u&&p[r].regexp.test(u))){return false;}}}if(q){for(r=q.length;r--;){n=q[r];if(n.operator?!n.test(this.getAttribute(o,n.key)):!this.hasAttribute(o,n.key)){return false;}}}if(s){for(r=s.length;r--;){n=s[r];if(!this.matchPseudo(o,n.key,n.value)){return false;}}}return true;};var j={" ":function(q,w,n,r,s,u,p){var t,v,o;if(this.isHTMLDocument){getById:if(n){v=this.document.getElementById(n);if((!v&&q.all)||(this.idGetsName&&v&&v.getAttributeNode("id").nodeValue!=n)){o=q.all[n];if(!o){return;}if(!o[0]){o=[o];}for(t=0;v=o[t++];){var c=v.getAttributeNode("id");if(c&&c.nodeValue==n){this.push(v,w,null,r,s,u);break;}}return;}if(!v){if(this.contains(this.root,q)){return;}else{break getById;}}else{if(this.document!==q&&!this.contains(q,v)){return;}}this.push(v,w,null,r,s,u);return;}getByClass:if(r&&q.getElementsByClassName&&!this.brokenGEBCN){o=q.getElementsByClassName(p.join(" "));if(!(o&&o.length)){break getByClass;}for(t=0;v=o[t++];){this.push(v,w,n,null,s,u);}return;}}getByTag:{o=q.getElementsByTagName(w);if(!(o&&o.length)){break getByTag;}if(!this.brokenStarGEBTN){w=null;}for(t=0;v=o[t++];){this.push(v,w,n,r,s,u);}}},">":function(p,c,r,o,n,q){if((p=p.firstChild)){do{if(p.nodeType==1){this.push(p,c,r,o,n,q);}}while((p=p.nextSibling));}},"+":function(p,c,r,o,n,q){while((p=p.nextSibling)){if(p.nodeType==1){this.push(p,c,r,o,n,q);break;}}},"^":function(p,c,r,o,n,q){p=p.firstChild;if(p){if(p.nodeType==1){this.push(p,c,r,o,n,q);}else{this["combinator:+"](p,c,r,o,n,q);}}},"~":function(q,c,s,p,n,r){while((q=q.nextSibling)){if(q.nodeType!=1){continue;}var o=this.getUID(q);if(this.bitUniques[o]){break;}this.bitUniques[o]=true;this.push(q,c,s,p,n,r);}},"++":function(p,c,r,o,n,q){this["combinator:+"](p,c,r,o,n,q);this["combinator:!+"](p,c,r,o,n,q);},"~~":function(p,c,r,o,n,q){this["combinator:~"](p,c,r,o,n,q);this["combinator:!~"](p,c,r,o,n,q);},"!":function(p,c,r,o,n,q){while((p=p.parentNode)){if(p!==this.document){this.push(p,c,r,o,n,q);}}},"!>":function(p,c,r,o,n,q){p=p.parentNode;if(p!==this.document){this.push(p,c,r,o,n,q);}},"!+":function(p,c,r,o,n,q){while((p=p.previousSibling)){if(p.nodeType==1){this.push(p,c,r,o,n,q);break;}}},"!^":function(p,c,r,o,n,q){p=p.lastChild;if(p){if(p.nodeType==1){this.push(p,c,r,o,n,q);}else{this["combinator:!+"](p,c,r,o,n,q);}}},"!~":function(q,c,s,p,n,r){while((q=q.previousSibling)){if(q.nodeType!=1){continue;}var o=this.getUID(q);if(this.bitUniques[o]){break;}this.bitUniques[o]=true;this.push(q,c,s,p,n,r);}}};for(var i in j){k["combinator:"+i]=j[i];}var l={empty:function(c){var n=c.firstChild;return !(n&&n.nodeType==1)&&!(c.innerText||c.textContent||"").length;},not:function(c,n){return !this.matchNode(c,n);},contains:function(c,n){return(c.innerText||c.textContent||"").indexOf(n)>-1;},"first-child":function(c){while((c=c.previousSibling)){if(c.nodeType==1){return false;}}return true;},"last-child":function(c){while((c=c.nextSibling)){if(c.nodeType==1){return false;}}return true;},"only-child":function(o){var n=o;while((n=n.previousSibling)){if(n.nodeType==1){return false;}}var c=o;while((c=c.nextSibling)){if(c.nodeType==1){return false;}}return true;},"nth-child":k.createNTHPseudo("firstChild","nextSibling","posNTH"),"nth-last-child":k.createNTHPseudo("lastChild","previousSibling","posNTHLast"),"nth-of-type":k.createNTHPseudo("firstChild","nextSibling","posNTHType",true),"nth-last-of-type":k.createNTHPseudo("lastChild","previousSibling","posNTHTypeLast",true),index:function(n,c){return this["pseudo:nth-child"](n,""+(c+1));},even:function(c){return this["pseudo:nth-child"](c,"2n");},odd:function(c){return this["pseudo:nth-child"](c,"2n+1");},"first-of-type":function(c){var n=c.nodeName;while((c=c.previousSibling)){if(c.nodeName==n){return false;}}return true;},"last-of-type":function(c){var n=c.nodeName;while((c=c.nextSibling)){if(c.nodeName==n){return false;}}return true;},"only-of-type":function(o){var n=o,p=o.nodeName;while((n=n.previousSibling)){if(n.nodeName==p){return false;}}var c=o;while((c=c.nextSibling)){if(c.nodeName==p){return false;}}return true;},enabled:function(c){return !c.disabled;},disabled:function(c){return c.disabled;},checked:function(c){return c.checked||c.selected;},focus:function(c){return this.isHTMLDocument&&this.document.activeElement===c&&(c.href||c.type||this.hasAttribute(c,"tabindex"));},root:function(c){return(c===this.root);},selected:function(c){return c.selected;}};for(var b in l){k["pseudo:"+b]=l[b];}var a=k.attributeGetters={"for":function(){return("htmlFor" in this)?this.htmlFor:this.getAttribute("for");},href:function(){return("href" in this)?this.getAttribute("href",2):this.getAttribute("href");},style:function(){return(this.style)?this.style.cssText:this.getAttribute("style");},tabindex:function(){var c=this.getAttributeNode("tabindex");return(c&&c.specified)?c.nodeValue:null;},type:function(){return this.getAttribute("type");},maxlength:function(){var c=this.getAttributeNode("maxLength");return(c&&c.specified)?c.nodeValue:null;}};a.MAXLENGTH=a.maxLength=a.maxlength;var e=k.Slick=(this.Slick||{});e.version="1.1.7";e.search=function(n,o,c){return k.search(n,o,c);};e.find=function(c,n){return k.search(c,n,null,true);};e.contains=function(c,n){k.setDocument(c);return k.contains(c,n);};e.getAttribute=function(n,c){k.setDocument(n);return k.getAttribute(n,c);};e.hasAttribute=function(n,c){k.setDocument(n);return k.hasAttribute(n,c);};e.match=function(n,c){if(!(n&&c)){return false;}if(!c||c===n){return true;}k.setDocument(n);return k.matchNode(n,c);};e.defineAttributeGetter=function(c,n){k.attributeGetters[c]=n;return this;};e.lookupAttributeGetter=function(c){return k.attributeGetters[c];};e.definePseudo=function(c,n){k["pseudo:"+c]=function(p,o){return n.call(p,o);};return this;};e.lookupPseudo=function(c){var n=k["pseudo:"+c];if(n){return function(o){return n.call(this,o);};}return null;};e.override=function(n,c){k.override(n,c);return this;};e.isXML=k.isXML;e.uidOf=function(c){return k.getUIDHTML(c);};if(!this.Slick){this.Slick=e;}}).apply((typeof exports!="undefined")?exports:this);var Element=function(b,g){var h=Element.Constructors[b];if(h){return h(g);}if(typeof b!="string"){return document.id(b).set(g);}if(!g){g={};}if(!(/^[\w-]+$/).test(b)){var e=Slick.parse(b).expressions[0][0];b=(e.tag=="*")?"div":e.tag;if(e.id&&g.id==null){g.id=e.id;}var d=e.attributes;if(d){for(var a,f=0,c=d.length;f<c;f++){a=d[f];if(g[a.key]!=null){continue;}if(a.value!=null&&a.operator=="="){g[a.key]=a.value;}else{if(!a.value&&!a.operator){g[a.key]=true;}}}}if(e.classList&&g["class"]==null){g["class"]=e.classList.join(" ");}}return document.newElement(b,g);};if(Browser.Element){Element.prototype=Browser.Element.prototype;Element.prototype._fireEvent=(function(a){return function(b,c){return a.call(this,b,c);};})(Element.prototype.fireEvent);}new Type("Element",Element).mirror(function(a){if(Array.prototype[a]){return;}var b={};b[a]=function(){var h=[],e=arguments,j=true;for(var g=0,d=this.length;g<d;g++){var f=this[g],c=h[g]=f[a].apply(f,e);j=(j&&typeOf(c)=="element");}return(j)?new Elements(h):h;};Elements.implement(b);});if(!Browser.Element){Element.parent=Object;Element.Prototype={"$constructor":Element,"$family":Function.from("element").hide()};Element.mirror(function(a,b){Element.Prototype[a]=b;});}Element.Constructors={};var IFrame=new Type("IFrame",function(){var e=Array.link(arguments,{properties:Type.isObject,iframe:function(f){return(f!=null);}});var c=e.properties||{},b;if(e.iframe){b=document.id(e.iframe);}var d=c.onload||function(){};delete c.onload;c.id=c.name=[c.id,c.name,b?(b.id||b.name):"IFrame_"+String.uniqueID()].pick();b=new Element(b||"iframe",c);var a=function(){d.call(b.contentWindow);};if(window.frames[c.id]){a();}else{b.addListener("load",a);}return b;});var Elements=this.Elements=function(a){if(a&&a.length){var e={},d;for(var c=0;d=a[c++];){var b=Slick.uidOf(d);if(!e[b]){e[b]=true;this.push(d);}}}};Elements.prototype={length:0};Elements.parent=Array;new Type("Elements",Elements).implement({filter:function(a,b){if(!a){return this;}return new Elements(Array.filter(this,(typeOf(a)=="string")?function(c){return c.match(a);}:a,b));}.protect(),push:function(){var d=this.length;for(var b=0,a=arguments.length;b<a;b++){var c=document.id(arguments[b]);if(c){this[d++]=c;}}return(this.length=d);}.protect(),unshift:function(){var b=[];for(var c=0,a=arguments.length;c<a;c++){var d=document.id(arguments[c]);if(d){b.push(d);}}return Array.prototype.unshift.apply(this,b);}.protect(),concat:function(){var b=new Elements(this);for(var c=0,a=arguments.length;c<a;c++){var d=arguments[c];if(Type.isEnumerable(d)){b.append(d);}else{b.push(d);}}return b;}.protect(),append:function(c){for(var b=0,a=c.length;b<a;b++){this.push(c[b]);}return this;}.protect(),empty:function(){while(this.length){delete this[--this.length];}return this;}.protect()});(function(){var f=Array.prototype.splice,a={"0":0,"1":1,length:2};f.call(a,1,1);if(a[1]==1){Elements.implement("splice",function(){var g=this.length;var e=f.apply(this,arguments);while(g>=this.length){delete this[g--];}return e;}.protect());}Array.forEachMethod(function(g,e){Elements.implement(e,g);});Array.mirror(Elements);var d;try{d=(document.createElement("<input name=x>").name=="x");}catch(b){}var c=function(e){return(""+e).replace(/&/g,"&amp;").replace(/"/g,"&quot;");};Document.implement({newElement:function(e,g){if(g&&g.checked!=null){g.defaultChecked=g.checked;}if(d&&g){e="<"+e;if(g.name){e+=' name="'+c(g.name)+'"';}if(g.type){e+=' type="'+c(g.type)+'"';}e+=">";delete g.name;delete g.type;}return this.id(this.createElement(e)).set(g);}});})();(function(){Slick.uidOf(window);Slick.uidOf(document);Document.implement({newTextNode:function(e){return this.createTextNode(e);},getDocument:function(){return this;},getWindow:function(){return this.window;},id:(function(){var e={string:function(E,D,l){E=Slick.find(l,"#"+E.replace(/(\W)/g,"\\$1"));return(E)?e.element(E,D):null;},element:function(D,E){Slick.uidOf(D);if(!E&&!D.$family&&!(/^(?:object|embed)$/i).test(D.tagName)){var l=D.fireEvent;D._fireEvent=function(F,G){return l(F,G);};Object.append(D,Element.Prototype);}return D;},object:function(D,E,l){if(D.toElement){return e.element(D.toElement(l),E);}return null;}};e.textnode=e.whitespace=e.window=e.document=function(l){return l;};return function(D,F,E){if(D&&D.$family&&D.uniqueNumber){return D;}var l=typeOf(D);return(e[l])?e[l](D,F,E||document):null;};})()});if(window.$==null){Window.implement("$",function(e,l){return document.id(e,l,this.document);});}Window.implement({getDocument:function(){return this.document;},getWindow:function(){return this;}});[Document,Element].invoke("implement",{getElements:function(e){return Slick.search(this,e,new Elements);},getElement:function(e){return document.id(Slick.find(this,e));}});var m={contains:function(e){return Slick.contains(this,e);}};if(!document.contains){Document.implement(m);}if(!document.createElement("div").contains){Element.implement(m);}var r=function(E,D){if(!E){return D;}E=Object.clone(Slick.parse(E));var l=E.expressions;for(var e=l.length;e--;){l[e][0].combinator=D;}return E;};Object.forEach({getNext:"~",getPrevious:"!~",getParent:"!"},function(e,l){Element.implement(l,function(D){return this.getElement(r(D,e));});});Object.forEach({getAllNext:"~",getAllPrevious:"!~",getSiblings:"~~",getChildren:">",getParents:"!"},function(e,l){Element.implement(l,function(D){return this.getElements(r(D,e));});});Element.implement({getFirst:function(e){return document.id(Slick.search(this,r(e,">"))[0]);},getLast:function(e){return document.id(Slick.search(this,r(e,">")).getLast());},getWindow:function(){return this.ownerDocument.window;},getDocument:function(){return this.ownerDocument;},getElementById:function(e){return document.id(Slick.find(this,"#"+(""+e).replace(/(\W)/g,"\\$1")));},match:function(e){return !e||Slick.match(this,e);}});if(window.$$==null){Window.implement("$$",function(e){if(arguments.length==1){if(typeof e=="string"){return Slick.search(this.document,e,new Elements);}else{if(Type.isEnumerable(e)){return new Elements(e);}}}return new Elements(arguments);});}var w={before:function(l,e){var D=e.parentNode;if(D){D.insertBefore(l,e);}},after:function(l,e){var D=e.parentNode;if(D){D.insertBefore(l,e.nextSibling);}},bottom:function(l,e){e.appendChild(l);},top:function(l,e){e.insertBefore(l,e.firstChild);}};w.inside=w.bottom;var j={},d={};var k={};Array.forEach(["type","value","defaultValue","accessKey","cellPadding","cellSpacing","colSpan","frameBorder","rowSpan","tabIndex","useMap"],function(e){k[e.toLowerCase()]=e;});k.html="innerHTML";k.text=(document.createElement("div").textContent==null)?"innerText":"textContent";Object.forEach(k,function(l,e){d[e]=function(D,E){D[l]=E;};j[e]=function(D){return D[l];};});var x=["compact","nowrap","ismap","declare","noshade","checked","disabled","readOnly","multiple","selected","noresize","defer","defaultChecked","autofocus","controls","autoplay","loop"];var h={};Array.forEach(x,function(e){var l=e.toLowerCase();h[l]=e;d[l]=function(D,E){D[e]=!!E;};j[l]=function(D){return !!D[e];};});Object.append(d,{"class":function(e,l){("className" in e)?e.className=(l||""):e.setAttribute("class",l);},"for":function(e,l){("htmlFor" in e)?e.htmlFor=l:e.setAttribute("for",l);},style:function(e,l){(e.style)?e.style.cssText=l:e.setAttribute("style",l);},value:function(e,l){e.value=(l!=null)?l:"";}});j["class"]=function(e){return("className" in e)?e.className||null:e.getAttribute("class");};var f=document.createElement("button");try{f.type="button";}catch(z){}if(f.type!="button"){d.type=function(e,l){e.setAttribute("type",l);};}f=null;var p=document.createElement("input");p.value="t";p.type="submit";if(p.value!="t"){d.type=function(l,e){var D=l.value;l.type=e;l.value=D;};}p=null;var q=(function(e){e.random="attribute";return(e.getAttribute("random")=="attribute");})(document.createElement("div"));Element.implement({setProperty:function(l,D){var E=d[l.toLowerCase()];if(E){E(this,D);}else{if(q){var e=this.retrieve("$attributeWhiteList",{});}if(D==null){this.removeAttribute(l);if(q){delete e[l];}}else{this.setAttribute(l,""+D);if(q){e[l]=true;}}}return this;},setProperties:function(e){for(var l in e){this.setProperty(l,e[l]);}return this;},getProperty:function(F){var D=j[F.toLowerCase()];if(D){return D(this);}if(q){var l=this.getAttributeNode(F),E=this.retrieve("$attributeWhiteList",{});if(!l){return null;}if(l.expando&&!E[F]){var G=this.outerHTML;if(G.substr(0,G.search(/\/?['"]?>(?![^<]*<['"])/)).indexOf(F)<0){return null;}E[F]=true;}}var e=Slick.getAttribute(this,F);return(!e&&!Slick.hasAttribute(this,F))?null:e;},getProperties:function(){var e=Array.from(arguments);return e.map(this.getProperty,this).associate(e);},removeProperty:function(e){return this.setProperty(e,null);},removeProperties:function(){Array.each(arguments,this.removeProperty,this);return this;},set:function(D,l){var e=Element.Properties[D];(e&&e.set)?e.set.call(this,l):this.setProperty(D,l);}.overloadSetter(),get:function(l){var e=Element.Properties[l];return(e&&e.get)?e.get.apply(this):this.getProperty(l);}.overloadGetter(),erase:function(l){var e=Element.Properties[l];(e&&e.erase)?e.erase.apply(this):this.removeProperty(l);return this;},hasClass:function(e){return this.className.clean().contains(e," ");},addClass:function(e){if(!this.hasClass(e)){this.className=(this.className+" "+e).clean();}return this;},removeClass:function(e){this.className=this.className.replace(new RegExp("(^|\\s)"+e+"(?:\\s|$)"),"$1");return this;},toggleClass:function(e,l){if(l==null){l=!this.hasClass(e);}return(l)?this.addClass(e):this.removeClass(e);},adopt:function(){var E=this,e,G=Array.flatten(arguments),F=G.length;if(F>1){E=e=document.createDocumentFragment();}for(var D=0;D<F;D++){var l=document.id(G[D],true);if(l){E.appendChild(l);}}if(e){this.appendChild(e);}return this;},appendText:function(l,e){return this.grab(this.getDocument().newTextNode(l),e);},grab:function(l,e){w[e||"bottom"](document.id(l,true),this);return this;},inject:function(l,e){w[e||"bottom"](this,document.id(l,true));return this;},replaces:function(e){e=document.id(e,true);e.parentNode.replaceChild(this,e);return this;},wraps:function(l,e){l=document.id(l,true);return this.replaces(l).grab(l,e);},getSelected:function(){this.selectedIndex;return new Elements(Array.from(this.options).filter(function(e){return e.selected;}));},toQueryString:function(){var e=[];this.getElements("input, select, textarea").each(function(D){var l=D.type;if(!D.name||D.disabled||l=="submit"||l=="reset"||l=="file"||l=="image"){return;}var E=(D.get("tag")=="select")?D.getSelected().map(function(F){return document.id(F).get("value");}):((l=="radio"||l=="checkbox")&&!D.checked)?null:D.get("value");Array.from(E).each(function(F){if(typeof F!="undefined"){e.push(encodeURIComponent(D.name)+"="+encodeURIComponent(F));}});});return e.join("&");}});var i={},A={};var B=function(e){return(A[e]||(A[e]={}));};var v=function(l){var e=l.uniqueNumber;if(l.removeEvents){l.removeEvents();}if(l.clearAttributes){l.clearAttributes();}if(e!=null){delete i[e];delete A[e];}return l;};var C={input:"checked",option:"selected",textarea:"value"};Element.implement({destroy:function(){var e=v(this).getElementsByTagName("*");Array.each(e,v);Element.dispose(this);return null;},empty:function(){Array.from(this.childNodes).each(Element.dispose);return this;},dispose:function(){return(this.parentNode)?this.parentNode.removeChild(this):this;},clone:function(G,E){G=G!==false;var L=this.cloneNode(G),D=[L],F=[this],J;if(G){D.append(Array.from(L.getElementsByTagName("*")));F.append(Array.from(this.getElementsByTagName("*")));}for(J=D.length;J--;){var H=D[J],K=F[J];if(!E){H.removeAttribute("id");}if(H.clearAttributes){H.clearAttributes();H.mergeAttributes(K);H.removeAttribute("uniqueNumber");if(H.options){var O=H.options,e=K.options;for(var I=O.length;I--;){O[I].selected=e[I].selected;}}}var l=C[K.tagName.toLowerCase()];if(l&&K[l]){H[l]=K[l];}}if(Browser.ie){var M=L.getElementsByTagName("object"),N=this.getElementsByTagName("object");for(J=M.length;J--;){M[J].outerHTML=N[J].outerHTML;}}return document.id(L);}});[Element,Window,Document].invoke("implement",{addListener:function(E,D){if(E=="unload"){var e=D,l=this;D=function(){l.removeListener("unload",D);e();};}else{i[Slick.uidOf(this)]=this;}if(this.addEventListener){this.addEventListener(E,D,!!arguments[2]);}else{this.attachEvent("on"+E,D);}return this;},removeListener:function(l,e){if(this.removeEventListener){this.removeEventListener(l,e,!!arguments[2]);}else{this.detachEvent("on"+l,e);}return this;},retrieve:function(l,e){var E=B(Slick.uidOf(this)),D=E[l];if(e!=null&&D==null){D=E[l]=e;}return D!=null?D:null;},store:function(l,e){var D=B(Slick.uidOf(this));D[l]=e;return this;},eliminate:function(e){var l=B(Slick.uidOf(this));delete l[e];return this;}});if(window.attachEvent&&!window.addEventListener){window.addListener("unload",function(){Object.each(i,v);if(window.CollectGarbage){CollectGarbage();}});}Element.Properties={};Element.Properties.style={set:function(e){this.style.cssText=e;},get:function(){return this.style.cssText;},erase:function(){this.style.cssText="";}};Element.Properties.tag={get:function(){return this.tagName.toLowerCase();}};Element.Properties.html={set:function(e){if(e==null){e="";}else{if(typeOf(e)=="array"){e=e.join("");}}this.innerHTML=e;},erase:function(){this.innerHTML="";}};var t=document.createElement("div");t.innerHTML="<nav></nav>";var a=(t.childNodes.length==1);if(!a){var s="abbr article aside audio canvas datalist details figcaption figure footer header hgroup mark meter nav output progress section summary time video".split(" "),b=document.createDocumentFragment(),u=s.length;while(u--){b.createElement(s[u]);}}t=null;var g=Function.attempt(function(){var e=document.createElement("table");e.innerHTML="<tr><td></td></tr>";return true;});var c=document.createElement("tr"),o="<td></td>";c.innerHTML=o;var y=(c.innerHTML==o);c=null;if(!g||!y||!a){Element.Properties.html.set=(function(l){var e={table:[1,"<table>","</table>"],select:[1,"<select>","</select>"],tbody:[2,"<table><tbody>","</tbody></table>"],tr:[3,"<table><tbody><tr>","</tr></tbody></table>"]};e.thead=e.tfoot=e.tbody;return function(D){var E=e[this.get("tag")];if(!E&&!a){E=[0,"",""];}if(!E){return l.call(this,D);}var H=E[0],G=document.createElement("div"),F=G;if(!a){b.appendChild(G);}G.innerHTML=[E[1],D,E[2]].flatten().join("");while(H--){F=F.firstChild;}this.empty().adopt(F.childNodes);if(!a){b.removeChild(G);}G=null;};})(Element.Properties.html.set);}var n=document.createElement("form");n.innerHTML="<select><option>s</option></select>";if(n.firstChild.value!="s"){Element.Properties.value={set:function(G){var l=this.get("tag");if(l!="select"){return this.setProperty("value",G);}var D=this.getElements("option");for(var E=0;E<D.length;E++){var F=D[E],e=F.getAttributeNode("value"),H=(e&&e.specified)?F.value:F.get("text");if(H==G){return F.selected=true;}}},get:function(){var D=this,l=D.get("tag");if(l!="select"&&l!="option"){return this.getProperty("value");}if(l=="select"&&!(D=D.getSelected()[0])){return"";}var e=D.getAttributeNode("value");return(e&&e.specified)?D.value:D.get("text");}};}n=null;if(document.createElement("div").getAttributeNode("id")){Element.Properties.id={set:function(e){this.id=this.getAttributeNode("id").value=e;},get:function(){return this.id||null;},erase:function(){this.id=this.getAttributeNode("id").value="";}};}})();(function(){var a=this.Class=new Type("Class",function(h){if(instanceOf(h,Function)){h={initialize:h};}var g=function(){e(this);if(g.$prototyping){return this;}this.$caller=null;var i=(this.initialize)?this.initialize.apply(this,arguments):this;this.$caller=this.caller=null;return i;}.extend(this).implement(h);g.$constructor=a;g.prototype.$constructor=g;g.prototype.parent=c;return g;});var c=function(){if(!this.$caller){throw new Error('The method "parent" cannot be called.');}var g=this.$caller.$name,h=this.$caller.$owner.parent,i=(h)?h.prototype[g]:null;if(!i){throw new Error('The method "'+g+'" has no parent.');}return i.apply(this,arguments);};var e=function(g){for(var h in g){var j=g[h];switch(typeOf(j)){case"object":var i=function(){};i.prototype=j;g[h]=e(new i);break;case"array":g[h]=j.clone();break;}}return g;};var b=function(g,h,j){if(j.$origin){j=j.$origin;}var i=function(){if(j.$protected&&this.$caller==null){throw new Error('The method "'+h+'" cannot be called.');}var l=this.caller,m=this.$caller;this.caller=m;this.$caller=i;var k=j.apply(this,arguments);this.$caller=m;this.caller=l;return k;}.extend({$owner:g,$origin:j,$name:h});return i;};var f=function(h,i,g){if(a.Mutators.hasOwnProperty(h)){i=a.Mutators[h].call(this,i);if(i==null){return this;}}if(typeOf(i)=="function"){if(i.$hidden){return this;}this.prototype[h]=(g)?i:b(this,h,i);}else{Object.merge(this.prototype,h,i);}return this;};var d=function(g){g.$prototyping=true;var h=new g;delete g.$prototyping;return h;};a.implement("implement",f.overloadSetter());a.Mutators={Extends:function(g){this.parent=g;this.prototype=d(g);},Implements:function(g){Array.from(g).each(function(j){var h=new j;for(var i in h){f.call(this,i,h[i],true);}},this);}};})();(function(){this.Chain=new Class({$chain:[],chain:function(){this.$chain.append(Array.flatten(arguments));return this;},callChain:function(){return(this.$chain.length)?this.$chain.shift().apply(this,arguments):false;},clearChain:function(){this.$chain.empty();return this;}});var a=function(b){return b.replace(/^on([A-Z])/,function(c,d){return d.toLowerCase();});};this.Events=new Class({$events:{},addEvent:function(d,c,b){d=a(d);this.$events[d]=(this.$events[d]||[]).include(c);if(b){c.internal=true;}return this;},addEvents:function(b){for(var c in b){this.addEvent(c,b[c]);}return this;},fireEvent:function(e,c,b){e=a(e);var d=this.$events[e];if(!d){return this;}c=Array.from(c);d.each(function(f){if(b){f.delay(b,this,c);}else{f.apply(this,c);}},this);return this;},removeEvent:function(e,d){e=a(e);var c=this.$events[e];if(c&&!d.internal){var b=c.indexOf(d);if(b!=-1){delete c[b];}}return this;},removeEvents:function(d){var e;if(typeOf(d)=="object"){for(e in d){this.removeEvent(e,d[e]);}return this;}if(d){d=a(d);}for(e in this.$events){if(d&&d!=e){continue;}var c=this.$events[e];for(var b=c.length;b--;){if(b in c){this.removeEvent(e,c[b]);}}}return this;}});this.Options=new Class({setOptions:function(){var b=this.options=Object.merge.apply(null,[{},this.options].append(arguments));if(this.addEvent){for(var c in b){if(typeOf(b[c])!="function"||!(/^on[A-Z]/).test(c)){continue;}this.addEvent(c,b[c]);delete b[c];}}return this;}});})();(function(){var d=function(){},a=("onprogress" in new Browser.Request);var c=this.Request=new Class({Implements:[Chain,Events,Options],options:{url:"",data:"",headers:{"X-Requested-With":"XMLHttpRequest",Accept:"text/javascript, text/html, application/xml, text/xml, */*"},async:true,format:false,method:"post",link:"ignore",isSuccess:null,emulation:true,urlEncoded:true,encoding:"utf-8",evalScripts:false,evalResponse:false,timeout:0,noCache:false},initialize:function(e){this.xhr=new Browser.Request();this.setOptions(e);this.headers=this.options.headers;},onStateChange:function(){var e=this.xhr;if(e.readyState!=4||!this.running){return;}this.running=false;this.status=0;Function.attempt(function(){var f=e.status;this.status=(f==1223)?204:f;}.bind(this));e.onreadystatechange=d;if(a){e.onprogress=e.onloadstart=d;}clearTimeout(this.timer);this.response={text:this.xhr.responseText||"",xml:this.xhr.responseXML};if(this.options.isSuccess.call(this,this.status)){this.success(this.response.text,this.response.xml);}else{this.failure();}},isSuccess:function(){var e=this.status;return(e>=200&&e<300);},isRunning:function(){return !!this.running;},processScripts:function(e){if(this.options.evalResponse||(/(ecma|java)script/).test(this.getHeader("Content-type"))){return Browser.exec(e);}return e.stripScripts(this.options.evalScripts);},success:function(f,e){this.onSuccess(this.processScripts(f),e);},onSuccess:function(){this.fireEvent("complete",arguments).fireEvent("success",arguments).callChain();},failure:function(){this.onFailure();},onFailure:function(){this.fireEvent("complete").fireEvent("failure",this.xhr);},loadstart:function(e){this.fireEvent("loadstart",[e,this.xhr]);},progress:function(e){this.fireEvent("progress",[e,this.xhr]);},timeout:function(){this.fireEvent("timeout",this.xhr);},setHeader:function(e,f){this.headers[e]=f;return this;},getHeader:function(e){return Function.attempt(function(){return this.xhr.getResponseHeader(e);}.bind(this));},check:function(){if(!this.running){return true;}switch(this.options.link){case"cancel":this.cancel();return true;case"chain":this.chain(this.caller.pass(arguments,this));return false;}return false;},send:function(o){if(!this.check(o)){return this;}this.options.isSuccess=this.options.isSuccess||this.isSuccess;this.running=true;var l=typeOf(o);if(l=="string"||l=="element"){o={data:o};}var h=this.options;o=Object.append({data:h.data,url:h.url,method:h.method},o);var j=o.data,f=String(o.url),e=o.method.toLowerCase();switch(typeOf(j)){case"element":j=document.id(j).toQueryString();break;case"object":case"hash":j=Object.toQueryString(j);}if(this.options.format){var m="format="+this.options.format;j=(j)?m+"&"+j:m;}if(this.options.emulation&&!["get","post"].contains(e)){var k="_method="+e;j=(j)?k+"&"+j:k;e="post";}if(this.options.urlEncoded&&["post","put"].contains(e)){var g=(this.options.encoding)?"; charset="+this.options.encoding:"";this.headers["Content-type"]="application/x-www-form-urlencoded"+g;}if(!f){f=document.location.pathname;}var i=f.lastIndexOf("/");if(i>-1&&(i=f.indexOf("#"))>-1){f=f.substr(0,i);}if(this.options.noCache){f+=(f.contains("?")?"&":"?")+String.uniqueID();}if(j&&e=="get"){f+=(f.contains("?")?"&":"?")+j;j=null;}var n=this.xhr;if(a){n.onloadstart=this.loadstart.bind(this);n.onprogress=this.progress.bind(this);}n.open(e.toUpperCase(),f,this.options.async,this.options.user,this.options.password);if(this.options.user&&"withCredentials" in n){n.withCredentials=true;}n.onreadystatechange=this.onStateChange.bind(this);Object.each(this.headers,function(q,p){try{n.setRequestHeader(p,q);}catch(r){this.fireEvent("exception",[p,q]);}},this);this.fireEvent("request");n.send(j);if(!this.options.async){this.onStateChange();}else{if(this.options.timeout){this.timer=this.timeout.delay(this.options.timeout,this);}}return this;},cancel:function(){if(!this.running){return this;}this.running=false;var e=this.xhr;e.abort();clearTimeout(this.timer);e.onreadystatechange=d;if(a){e.onprogress=e.onloadstart=d;}this.xhr=new Browser.Request();this.fireEvent("cancel");return this;}});var b={};["get","post","put","delete","GET","POST","PUT","DELETE"].each(function(e){b[e]=function(g){var f={method:e};if(g!=null){f.data=g;}return this.send(f);};});c.implement(b);Element.Properties.send={set:function(e){var f=this.get("send").cancel();f.setOptions(e);return this;},get:function(){var e=this.retrieve("send");if(!e){e=new c({data:this,link:"cancel",method:this.get("method")||"post",url:this.get("action")});this.store("send",e);}return e;}};Element.implement({send:function(e){var f=this.get("send");f.send({data:this,url:e||f.options.url});return this;}});})();if(typeof JSON=="undefined"){this.JSON={};}(function(){var special={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"};var escape=function(chr){return special[chr]||"\\u"+("0000"+chr.charCodeAt(0).toString(16)).slice(-4);};JSON.validate=function(string){string=string.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,"");return(/^[\],:{}\s]*$/).test(string);};JSON.encode=JSON.stringify?function(obj){return JSON.stringify(obj);}:function(obj){if(obj&&obj.toJSON){obj=obj.toJSON();}switch(typeOf(obj)){case"string":return'"'+obj.replace(/[\x00-\x1f\\"]/g,escape)+'"';case"array":return"["+obj.map(JSON.encode).clean()+"]";case"object":case"hash":var string=[];Object.each(obj,function(value,key){var json=JSON.encode(value);if(json){string.push(JSON.encode(key)+":"+json);}});return"{"+string+"}";case"number":case"boolean":return""+obj;case"null":return"null";}return null;};JSON.decode=function(string,secure){if(!string||typeOf(string)!="string"){return null;}if(secure||JSON.secure){if(JSON.parse){return JSON.parse(string);}if(!JSON.validate(string)){throw new Error("JSON could not decode the input; security is enabled and the value is not secure.");}}return eval("("+string+")");};})();Request.JSON=new Class({Extends:Request,options:{secure:true},initialize:function(a){this.parent(a);Object.append(this.headers,{Accept:"application/json","X-Request":"JSON"});},success:function(c){var b;try{b=this.response.json=JSON.decode(c,this.options.secure);}catch(a){this.fireEvent("error",[c,a]);return;}if(b==null){this.onFailure();}else{this.onSuccess(b,c);}}});(function(){var b={};var a=this.DOMEvent=new Type("DOMEvent",function(c,g){if(!g){g=window;}c=c||g.event;if(c.$extended){return c;}this.event=c;this.$extended=true;this.shift=c.shiftKey;this.control=c.ctrlKey;this.alt=c.altKey;this.meta=c.metaKey;var i=this.type=c.type;var h=c.target||c.srcElement;while(h&&h.nodeType==3){h=h.parentNode;}this.target=document.id(h);if(i.indexOf("key")==0){var d=this.code=(c.which||c.keyCode);this.key=b[d];if(i=="keydown"){if(d>111&&d<124){this.key="f"+(d-111);}else{if(d>95&&d<106){this.key=d-96;}}}if(this.key==null){this.key=String.fromCharCode(d).toLowerCase();}}else{if(i=="click"||i=="dblclick"||i=="contextmenu"||i=="DOMMouseScroll"||i.indexOf("mouse")==0){var j=g.document;j=(!j.compatMode||j.compatMode=="CSS1Compat")?j.html:j.body;this.page={x:(c.pageX!=null)?c.pageX:c.clientX+j.scrollLeft,y:(c.pageY!=null)?c.pageY:c.clientY+j.scrollTop};this.client={x:(c.pageX!=null)?c.pageX-g.pageXOffset:c.clientX,y:(c.pageY!=null)?c.pageY-g.pageYOffset:c.clientY};if(i=="DOMMouseScroll"||i=="mousewheel"){this.wheel=(c.wheelDelta)?c.wheelDelta/120:-(c.detail||0)/3;}this.rightClick=(c.which==3||c.button==2);if(i=="mouseover"||i=="mouseout"){var k=c.relatedTarget||c[(i=="mouseover"?"from":"to")+"Element"];while(k&&k.nodeType==3){k=k.parentNode;}this.relatedTarget=document.id(k);}}else{if(i.indexOf("touch")==0||i.indexOf("gesture")==0){this.rotation=c.rotation;this.scale=c.scale;this.targetTouches=c.targetTouches;this.changedTouches=c.changedTouches;var f=this.touches=c.touches;if(f&&f[0]){var e=f[0];this.page={x:e.pageX,y:e.pageY};this.client={x:e.clientX,y:e.clientY};}}}}if(!this.client){this.client={};}if(!this.page){this.page={};}});a.implement({stop:function(){return this.preventDefault().stopPropagation();},stopPropagation:function(){if(this.event.stopPropagation){this.event.stopPropagation();}else{this.event.cancelBubble=true;}return this;},preventDefault:function(){if(this.event.preventDefault){this.event.preventDefault();}else{this.event.returnValue=false;}return this;}});a.defineKey=function(d,c){b[d]=c;return this;};a.defineKeys=a.defineKey.overloadSetter(true);a.defineKeys({"38":"up","40":"down","37":"left","39":"right","27":"esc","32":"space","8":"backspace","9":"tab","46":"delete","13":"enter"});})();(function(){Element.Properties.events={set:function(b){this.addEvents(b);}};[Element,Window,Document].invoke("implement",{addEvent:function(f,h){var i=this.retrieve("events",{});if(!i[f]){i[f]={keys:[],values:[]};}if(i[f].keys.contains(h)){return this;}i[f].keys.push(h);var g=f,b=Element.Events[f],d=h,j=this;if(b){if(b.onAdd){b.onAdd.call(this,h,f);}if(b.condition){d=function(k){if(b.condition.call(this,k,f)){return h.call(this,k);}return true;};}if(b.base){g=Function.from(b.base).call(this,f);}}var e=function(){return h.call(j);};var c=Element.NativeEvents[g];if(c){if(c==2){e=function(k){k=new DOMEvent(k,j.getWindow());if(d.call(j,k)===false){k.stop();}};}this.addListener(g,e,arguments[2]);}i[f].values.push(e);return this;},removeEvent:function(e,d){var c=this.retrieve("events");if(!c||!c[e]){return this;}var h=c[e];var b=h.keys.indexOf(d);if(b==-1){return this;}var g=h.values[b];delete h.keys[b];delete h.values[b];var f=Element.Events[e];if(f){if(f.onRemove){f.onRemove.call(this,d,e);}if(f.base){e=Function.from(f.base).call(this,e);}}return(Element.NativeEvents[e])?this.removeListener(e,g,arguments[2]):this;},addEvents:function(b){for(var c in b){this.addEvent(c,b[c]);}return this;},removeEvents:function(b){var d;if(typeOf(b)=="object"){for(d in b){this.removeEvent(d,b[d]);}return this;}var c=this.retrieve("events");if(!c){return this;}if(!b){for(d in c){this.removeEvents(d);}this.eliminate("events");}else{if(c[b]){c[b].keys.each(function(e){this.removeEvent(b,e);},this);delete c[b];}}return this;},fireEvent:function(e,c,b){var d=this.retrieve("events");if(!d||!d[e]){return this;}c=Array.from(c);d[e].keys.each(function(f){if(b){f.delay(b,this,c);}else{f.apply(this,c);}},this);return this;},cloneEvents:function(e,d){e=document.id(e);var c=e.retrieve("events");if(!c){return this;}if(!d){for(var b in c){this.cloneEvents(e,b);}}else{if(c[d]){c[d].keys.each(function(f){this.addEvent(d,f);},this);}}return this;}});Element.NativeEvents={click:2,dblclick:2,mouseup:2,mousedown:2,contextmenu:2,mousewheel:2,DOMMouseScroll:2,mouseover:2,mouseout:2,mousemove:2,selectstart:2,selectend:2,keydown:2,keypress:2,keyup:2,orientationchange:2,touchstart:2,touchmove:2,touchend:2,touchcancel:2,gesturestart:2,gesturechange:2,gestureend:2,focus:2,blur:2,change:2,reset:2,select:2,submit:2,paste:2,input:2,load:2,unload:1,beforeunload:2,resize:1,move:1,DOMContentLoaded:1,readystatechange:1,error:1,abort:1,scroll:1};Element.Events={mousewheel:{base:(Browser.firefox)?"DOMMouseScroll":"mousewheel"}};if("onmouseenter" in document.documentElement){Element.NativeEvents.mouseenter=Element.NativeEvents.mouseleave=2;}else{var a=function(b){var c=b.relatedTarget;if(c==null){return true;}if(!c){return false;}return(c!=this&&c.prefix!="xul"&&typeOf(this)!="document"&&!this.contains(c));};Element.Events.mouseenter={base:"mouseover",condition:a};Element.Events.mouseleave={base:"mouseout",condition:a};}if(!window.addEventListener){Element.NativeEvents.propertychange=2;Element.Events.change={base:function(){var b=this.type;return(this.get("tag")=="input"&&(b=="radio"||b=="checkbox"))?"propertychange":"change";},condition:function(b){return this.type!="radio"||(b.event.propertyName=="checked"&&this.checked);}};}})();(function(i,k){var l,f,e=[],c,b,d=k.createElement("div");var g=function(){clearTimeout(b);if(l){return;}Browser.loaded=l=true;k.removeListener("DOMContentLoaded",g).removeListener("readystatechange",a);k.fireEvent("domready");i.fireEvent("domready");};var a=function(){for(var m=e.length;m--;){if(e[m]()){g();return true;}}return false;};var j=function(){clearTimeout(b);if(!a()){b=setTimeout(j,10);}};k.addListener("DOMContentLoaded",g);var h=function(){try{d.doScroll();return true;}catch(m){}return false;};if(d.doScroll&&!h()){e.push(h);c=true;}if(k.readyState){e.push(function(){var m=k.readyState;return(m=="loaded"||m=="complete");});}if("onreadystatechange" in k){k.addListener("readystatechange",a);}else{c=true;}if(c){j();}Element.Events.domready={onAdd:function(m){if(l){m.call(this);}}};Element.Events.load={base:"load",onAdd:function(m){if(f&&this==i){m.call(this);}},condition:function(){if(this==i){g();delete Element.Events.load;}return true;}};i.addEvent("load",function(){f=true;});})(window,document);<?php class Diff_View{private $a=null;private $b=null;private $groupedCodes=null;private $defaultOptions=array('context'=>3,'ignoreNewLines'=>false,'ignoreWhitespace'=>false,'ignoreCase'=>false);private $options=array();public function __construct($a,$b,$options=array()){$this->a=$a;$this->b=$b;if(is_array($options)) $this->options=array_merge($this->defaultOptions,$options);else $this->options=$this->defaultOptions;}public function render(Diff_View_Renderer_Abstract $renderer){$renderer->diff=$this;return $renderer->render();}public function getA($start=0,$end=null){if($start==0&&$end===null){return $this->a;}if($end===null){$length=1;}else{$length=$end-$start;}return array_slice($this->a,$start,$length);}public function getB($start=0,$end=null){if($start==0&&$end===null){return $this->b;}if($end===null){$length=1;}else{$length=$end-$start;}return array_slice($this->b,$start,$length);}public function getGroupedOpcodes(){if(!is_null($this->groupedCodes)){return $this->groupedCodes;}$sequenceMatcher=new Diff_View_SequenceMatcher($this->a,$this->b,null,$this->options);$this->groupedCodes=$sequenceMatcher->getGroupedOpcodes();return $this->groupedCodes;}}class Diff_View_SequenceMatcher{private $junkCallback=null;private $a=null;private $b=null;private $junkDict=array();private $b2j=array();private $options=array();private $defaultOptions=array('ignoreNewLines'=>false,'ignoreWhitespace'=>false,'ignoreCase'=>false);public function __construct($a,$b,$junkCallback=null,$options){$this->a=null;$this->b=null;$this->junkCallback=$junkCallback;$this->setOptions($options);$this->setSequences($a,$b);}public function setOptions($options){$this->options=array_merge($this->defaultOptions,$options);}public function setSequences($a,$b){$this->setSeq1($a);$this->setSeq2($b);}public function setSeq1($a){if(!is_array($a)){$a=str_split($a);}if($a==$this->a){return;}$this->a= $a;$this->matchingBlocks=null;$this->opCodes=null;}public function setSeq2($b){if(!is_array($b)){$b=str_split($b);}if($b==$this->b){return;}$this->b=$b;$this->matchingBlocks=null;$this->opCodes=null;$this->fullBCount=null;$this->chainB();}private function chainB(){$length=count($this->b);$this->b2j=array();$popularDict=array();for($i=0;$i < $length;++$i){$char=$this->b[$i];if(isset($this->b2j[$char])){if($length >= 200&&count($this->b2j[$char]) * 100>$length){$popularDict[$char]=1;unset($this->b2j[$char]);}else{$this->b2j[$char][]=$i;}}else{$this->b2j[$char]=array( $i);}}foreach(array_keys($popularDict) as $char){unset($this->b2j[$char]);}$this->junkDict=array();if(is_callable($this->junkCallback)){foreach(array_keys($popularDict) as $char){if(call_user_func($this->junkCallback,$char)){$this->junkDict[$char]=1;unset($popularDict[$char]);}}foreach(array_keys($this->b2j) as $char){if(call_user_func($this->junkCallback,$char)){$this->junkDict[$char]=1;unset($this->b2j[$char]);}}}}private function isBJunk($b){if(isset($this->juncDict[$b])){return true;}return false;}public function findLongestMatch($alo,$ahi,$blo,$bhi){$a=$this->a;$b=$this->b;$bestI=$alo;$bestJ=$blo;$bestSize=0;$j2Len=array();$nothing=array();for($i=$alo;$i < $ahi;++$i){$newJ2Len=array();$jDict=$this->arrayGetDefault($this->b2j,$a[$i],$nothing);foreach($jDict as $jKey=>$j){if($j < $blo){continue;}else if($j >= $bhi){break;}$k=$this->arrayGetDefault($j2Len,$j -1,0)+1;$newJ2Len[$j]=$k;if($k>$bestSize){$bestI=$i-$k+1;$bestJ=$j-$k+1;$bestSize=$k;}}$j2Len=$newJ2Len;}while($bestI>$alo&&$bestJ>$blo&&!$this->isBJunk($b[$bestJ-1])&&!$this->linesAreDifferent($bestI-1,$bestJ-1)){--$bestI;--$bestJ;++$bestSize;}while($bestI+$bestSize < $ahi&&($bestJ+$bestSize) < $bhi&&!$this->isBJunk($b[$bestJ+$bestSize])&&!$this->linesAreDifferent($bestI+$bestSize,$bestJ+$bestSize)){++$bestSize;}while($bestI>$alo&&$bestJ>$blo&&$this->isBJunk($b[$bestJ-1])&&!$this->isLineDifferent($bestI-1,$bestJ-1)){--$bestI;--$bestJ;++$bestSize;}while($bestI+$bestSize < $ahi&&$bestJ+$bestSize < $bhi&&$this->isBJunk($b[$bestJ+$bestSize])&&!$this->linesAreDifferent($bestI+$bestSize,$bestJ+$bestSize)){++$bestSize;}return array( $bestI,$bestJ,$bestSize);}public function linesAreDifferent($aIndex,$bIndex){$lineA=$this->a[$aIndex];$lineB=$this->b[$bIndex];if($this->options['ignoreWhitespace']){$replace=array("\t",' ');$lineA=str_replace($replace,'',$lineA);$lineB=str_replace($replace,'',$lineB);}if($this->options['ignoreCase']){$lineA=strtolower($lineA);$lineB=strtolower($lineB);}if($lineA!=$lineB){return true;}return false;}public function getMatchingBlocks(){if(!empty($this->matchingBlocks)){return $this->matchingBlocks;}$aLength=count($this->a);$bLength=count($this->b);$queue=array( array( 0,$aLength,0,$bLength));$matchingBlocks=array();while(!empty($queue)){list($alo,$ahi,$blo,$bhi)=array_pop($queue);$x=$this->findLongestMatch($alo,$ahi,$blo,$bhi);list($i,$j,$k)=$x;if($k){$matchingBlocks[]=$x;if($alo < $i&&$blo < $j){$queue[]=array( $alo,$i,$blo,$j);}if($i+$k < $ahi&&$j+$k < $bhi){$queue[]=array( $i+$k,$ahi,$j+$k,$bhi);}}}usort($matchingBlocks,array($this,'tupleSort'));$i1=0;$j1=0;$k1=0;$nonAdjacent=array();foreach($matchingBlocks as $block){list($i2,$j2,$k2)=$block;if($i1+$k1==$i2&&$j1+$k1==$j2){$k1 += $k2;}else{if($k1){$nonAdjacent[]=array( $i1,$j1,$k1);}$i1=$i2;$j1=$j2;$k1=$k2;}}if($k1){$nonAdjacent[]=array( $i1,$j1,$k1);}$nonAdjacent[]=array( $aLength,$bLength,0);$this->matchingBlocks=$nonAdjacent;return $this->matchingBlocks;}public function getOpCodes(){if(!empty($this->opCodes)){return $this->opCodes;}$i=0;$j=0;$this->opCodes=array();$blocks=$this->getMatchingBlocks();foreach($blocks as $block){list($ai,$bj,$size)=$block;$tag='';if($i < $ai&&$j < $bj){$tag='replace';}else if($i < $ai){$tag='delete';}else if($j < $bj){$tag='insert';}if($tag){$this->opCodes[]=array( $tag,$i,$ai,$j,$bj);}$i=$ai+$size;$j=$bj+$size;if($size){$this->opCodes[]=array('equal',$ai,$i,$bj,$j);}}return $this->opCodes;}public function getGroupedOpcodes($context=3){$opCodes=$this->getOpCodes();if(empty($opCodes)){$opCodes=array( array('equal',0,1,0,1));}if($opCodes[0][0]=='equal'){$opCodes[0]=array( $opCodes[0][0],max($opCodes[0][1],$opCodes[0][2]-$context),$opCodes[0][2],max($opCodes[0][3],$opCodes[0][4]-$context),$opCodes[0][4]);}$lastItem=count($opCodes)-1;if($opCodes[$lastItem][0]=='equal'){list($tag,$i1,$i2,$j1,$j2)=$opCodes[$lastItem];$opCodes[$lastItem]=array( $tag,$i1,min($i2,$i1+$context),$j1,min($j2,$j1+$context));}$maxRange=$context * 2;$groups=array();$group=array();foreach($opCodes as $code){list($tag,$i1,$i2,$j1,$j2)=$code;if($tag=='equal'&& $i2-$i1>$maxRange){$group[]=array( $tag,$i1,min($i2,$i1+$context),$j1,min($j2,$j1+$context));$groups[]=$group;$group=array();$i1=max($i1,$i2-$context);$j1=max($j1,$j2-$context);}$group[]=array( $tag,$i1,$i2,$j1,$j2);}if(!empty($group)&&!(count($group)==1&&$group[0][0]=='equal')){$groups[]=$group;}return $groups;}public function Ratio(){$matches=array_reduce($this->getMatchingBlocks(),array($this,'ratioReduce'),0);return $this->calculateRatio($matches,count($this->a)+count($this->b));}private function ratioReduce($sum,$triple){return $sum +($triple[count($triple)-1]);}private function quickRatio(){if($this->fullBCount===null){$this->fullBCount=array();$bLength=count($this->b);for($i=0;$i < $bLength;++$i){$char=$this->b[$i];$this->fullBCount[$char]=$this->arrayGetDefault($this->fullBCount,$char,0)+1;}}$avail=array();$matches=0;$aLength=count($this->a);for($i=0;$i < $aLength;++$i){$char=$this->a[$i];if(isset($avail[$char])){$numb=$avail[$char];}else{$numb=$this->arrayGetDefault($this->fullBCount,$char,0);}$avail[$char]=$numb-1;if($numb>0){++$matches;}}$this->calculateRatio($matches,count($this->a)+count($this->b));}private function realquickRatio(){$aLength=count($this->a);$bLength=count($this->b);return $this->calculateRatio(min($aLength,$bLength),$aLength+$bLength);}private function calculateRatio($matches,$length=0){if($length){return 2 *($matches / $length);}else{return 1;}}private function arrayGetDefault($array,$key,$default){if(isset($array[$key])){return $array[$key];}else{return $default;}}private function tupleSort($a,$b){$max=max(count($a),count($b));for($i=0;$i < $max;++$i){if($a[$i] < $b[$i]){return -1;}else if($a[$i]>$b[$i]){return 1;}}if(count($a)==count($b)){return 0;}else if(count($a) < count($b)){return -1;}else{return 1;}}}abstract class Diff_View_Renderer_Abstract{public $diff;protected $defaultOptions=array();protected $options=array();public function __construct(array $options=array()){$this->setOptions($options);}public function setOptions(array $options){$this->options=array_merge($this->defaultOptions,$options);}}class Diff_View_Renderer_Html_Array extends Diff_View_Renderer_Abstract{protected $defaultOptions=array('tabSize'=>4);public function render(){$a=$this->diff->getA();$b=$this->diff->getB();$changes=array();$opCodes=$this->diff->getGroupedOpcodes();foreach($opCodes as $group){$blocks=array();$lastTag=null;$lastBlock=0;foreach($group as $code){list($tag,$i1,$i2,$j1,$j2)=$code;if($tag=='replace'&& $i2-$i1==$j2-$j1){for($i=0;$i <($i2-$i1);++$i){$fromLine=$a[$i1+$i];$toLine=$b[$j1+$i];list($start,$end)=$this->getChangeExtent($fromLine,$toLine);if($start!=0||$end!=0){$last=$end+strlen($fromLine);$fromLine=substr_replace($fromLine,"\0",$start,0);$fromLine=substr_replace($fromLine,"\1",$last+1,0);$last=$end+strlen($toLine);$toLine=substr_replace($toLine,"\0",$start,0);$toLine=substr_replace($toLine,"\1",$last+1,0);$a[$i1+$i]=$fromLine;$b[$j1+$i]=$toLine;}}}if($tag!=$lastTag){$blocks[]=array('tag'=>$tag,'base'=>array('offset'=>$i1,'lines'=>array()),'changed'=>array('offset'=>$j1,'lines'=>array()));$lastBlock=count($blocks)-1;}$lastTag=$tag;if($tag=='equal'){$lines=array_slice($a,$i1,($i2-$i1));$blocks[$lastBlock]['base']['lines'] += $this->formatLines($lines);$lines=array_slice($b,$j1,($j2-$j1));$blocks[$lastBlock]['changed']['lines'] += $this->formatLines($lines);}else{if($tag=='replace'|| $tag=='delete'){$lines=array_slice($a,$i1,($i2-$i1));$lines=$this->formatLines($lines);$lines=str_replace(array("\0","\1"),array('<del>','</del>'),$lines);$blocks[$lastBlock]['base']['lines'] += $lines;}if($tag=='replace'|| $tag=='insert'){$lines=array_slice($b,$j1,($j2-$j1));$lines=$this->formatLines($lines);$lines=str_replace(array("\0","\1"),array('<ins>','</ins>'),$lines);$blocks[$lastBlock]['changed']['lines'] += $lines;}}}$changes[]=$blocks;}return $changes;}private function getChangeExtent($fromLine,$toLine){$start=0;$limit=min(strlen($fromLine),strlen($toLine));while($start < $limit&&$fromLine{$start}==$toLine{$start}){++$start;}$end=-1;$limit=$limit-$start;while(-$end <= $limit&&substr($fromLine,$end,1)==substr($toLine,$end,1)){--$end;}return array( $start,$end+1);}private function formatLines($lines){$lines=array_map(array($this,'ExpandTabs'),$lines);$lines=array_map(array($this,'HtmlSafe'),$lines);foreach($lines as &$line){$line=preg_replace_callback('# ( +)|^ #',__CLASS__."::fixSpaces",$line);}return $lines;}public static function fixSpaces($matches){$spaces=isset($matches[1])?$matches[1]:'';$count=strlen($spaces);if($count==0){return'';}$div=floor($count / 2);$mod=$count % 2;return str_repeat('&nbsp; ',$div).str_repeat('&nbsp;',$mod);}private function expandTabs($line){return str_replace("\t",str_repeat(' ',$this->options['tabSize']),$line);}private function htmlSafe($string){return htmlspecialchars($string,ENT_NOQUOTES,'UTF-8');}}class Diff_View_Renderer_Html_Contao extends Diff_View_Renderer_Html_Array{public function render(){$changes=parent::render();if(empty($changes)){return'';}$html="\n".'<div class="change">';if(isset($this->options['field'])){$html.="\n<h2>".$this->options['field'].'</h2>';}$html.="\n<ul>";foreach($changes as $i=>$blocks){if($i>0){$html.='<li class="skipped">…</li>';}foreach($blocks as $change){if($change['tag']=='equal'){foreach($change['base']['lines'] as $line){$html.="\n ".'<li class="'.$change['tag'].' left">'.($line?:'&nbsp;').'</li>';}}elseif($change['tag']=='insert'){foreach($change['changed']['lines'] as $line){$html.="\n ".'<li class="'.$change['tag'].' right"><ins>'.($line?:'&nbsp;').'</ins></li>';}}elseif($change['tag']=='delete'){foreach($change['base']['lines'] as $line){$html.="\n ".'<li class="'.$change['tag'].' left"><del>'.($line?:'&nbsp;').'</del></li>';}}elseif($change['tag']=='replace'){foreach($change['base']['lines'] as $line){$html.="\n ".'<li class="'.$change['tag'].' left"><span>'.($line?:'&nbsp;').'</span></li>';}foreach($change['changed']['lines'] as $line){$html.="\n ".'<li class="'.$change['tag'].' right"><span>'.($line?:'&nbsp;').'</span></li>';}}}}$html.="\n</ul>\n</div>\n";return $html;}}y=}gRֆHn-   GBMB